/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.NoSuchFileException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NotSerializableExceptionWrapper;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.text.Text;
import org.joda.time.ReadableInstant;

public abstract class StreamOutput
extends OutputStream {
    private Version version = Version.CURRENT;
    private final BytesRefBuilder spare = new BytesRefBuilder();
    private static byte ZERO = 0;
    private static byte ONE = 1;
    private static byte TWO = (byte)2;

    public Version getVersion() {
        return this.version;
    }

    public StreamOutput setVersion(Version version) {
        this.version = version;
        return this;
    }

    public long position() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void seek(long position) throws IOException {
        throw new UnsupportedOperationException();
    }

    public abstract void writeByte(byte var1) throws IOException;

    public void writeBytes(byte[] b) throws IOException {
        this.writeBytes(b, 0, b.length);
    }

    public void writeBytes(byte[] b, int length) throws IOException {
        this.writeBytes(b, 0, length);
    }

    public abstract void writeBytes(byte[] var1, int var2, int var3) throws IOException;

    public void writeByteArray(byte[] b) throws IOException {
        this.writeVInt(b.length);
        this.writeBytes(b, 0, b.length);
    }

    public void writeBytesReference(@Nullable BytesReference bytes) throws IOException {
        if (bytes == null) {
            this.writeVInt(0);
            return;
        }
        this.writeVInt(bytes.length());
        bytes.writeTo(this);
    }

    public void writeBytesRef(BytesRef bytes) throws IOException {
        if (bytes == null) {
            this.writeVInt(0);
            return;
        }
        this.writeVInt(bytes.length);
        this.write(bytes.bytes, bytes.offset, bytes.length);
    }

    public final void writeShort(short v) throws IOException {
        this.writeByte((byte)(v >> 8));
        this.writeByte((byte)v);
    }

    public void writeInt(int i) throws IOException {
        this.writeByte((byte)(i >> 24));
        this.writeByte((byte)(i >> 16));
        this.writeByte((byte)(i >> 8));
        this.writeByte((byte)i);
    }

    public void writeVInt(int i) throws IOException {
        while ((i & 0xFFFFFF80) != 0) {
            this.writeByte((byte)(i & 0x7F | 0x80));
            i >>>= 7;
        }
        this.writeByte((byte)i);
    }

    public void writeLong(long i) throws IOException {
        this.writeInt((int)(i >> 32));
        this.writeInt((int)i);
    }

    public void writeVLong(long i) throws IOException {
        assert (i >= 0L);
        while ((i & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.writeByte((byte)(i & 0x7FL | 0x80L));
            i >>>= 7;
        }
        this.writeByte((byte)i);
    }

    public void writeOptionalString(@Nullable String str) throws IOException {
        if (str == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeString(str);
        }
    }

    public void writeOptionalVInt(@Nullable Integer integer) throws IOException {
        if (integer == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writeVInt(integer);
        }
    }

    public void writeOptionalText(@Nullable Text text) throws IOException {
        if (text == null) {
            this.writeInt(-1);
        } else {
            this.writeText(text);
        }
    }

    public void writeText(Text text) throws IOException {
        if (!text.hasBytes()) {
            String string = text.string();
            this.spare.copyChars((CharSequence)string);
            this.writeInt(this.spare.length());
            this.write(this.spare.bytes(), 0, this.spare.length());
        } else {
            BytesReference bytes = text.bytes();
            this.writeInt(bytes.length());
            bytes.writeTo(this);
        }
    }

    public void writeString(String str) throws IOException {
        int charCount = str.length();
        this.writeVInt(charCount);
        for (int i = 0; i < charCount; ++i) {
            char c = str.charAt(i);
            if (c <= '\u007f') {
                this.writeByte((byte)c);
                continue;
            }
            if (c > '\u07ff') {
                this.writeByte((byte)(0xE0 | c >> 12 & 0xF));
                this.writeByte((byte)(0x80 | c >> 6 & 0x3F));
                this.writeByte((byte)(0x80 | c >> 0 & 0x3F));
                continue;
            }
            this.writeByte((byte)(0xC0 | c >> 6 & 0x1F));
            this.writeByte((byte)(0x80 | c >> 0 & 0x3F));
        }
    }

    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public void writeBoolean(boolean b) throws IOException {
        this.writeByte(b ? ONE : ZERO);
    }

    public void writeOptionalBoolean(@Nullable Boolean b) throws IOException {
        if (b == null) {
            this.writeByte(TWO);
        } else {
            this.writeByte(b != false ? ONE : ZERO);
        }
    }

    @Override
    public abstract void flush() throws IOException;

    @Override
    public abstract void close() throws IOException;

    public abstract void reset() throws IOException;

    @Override
    public void write(int b) throws IOException {
        this.writeByte((byte)b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.writeBytes(b, off, len);
    }

    public void writeStringArray(String[] array) throws IOException {
        this.writeVInt(array.length);
        for (String s : array) {
            this.writeString(s);
        }
    }

    public void writeStringArrayNullable(@Nullable String[] array) throws IOException {
        if (array == null) {
            this.writeVInt(0);
        } else {
            this.writeVInt(array.length);
            for (String s : array) {
                this.writeString(s);
            }
        }
    }

    public void writeMap(@Nullable Map<String, Object> map) throws IOException {
        this.writeGenericValue(map);
    }

    public void writeGenericValue(@Nullable Object value) throws IOException {
        if (value == null) {
            this.writeByte((byte)-1);
            return;
        }
        Class<?> type = value.getClass();
        if (type == String.class) {
            this.writeByte((byte)0);
            this.writeString((String)value);
        } else if (type == Integer.class) {
            this.writeByte((byte)1);
            this.writeInt((Integer)value);
        } else if (type == Long.class) {
            this.writeByte((byte)2);
            this.writeLong((Long)value);
        } else if (type == Float.class) {
            this.writeByte((byte)3);
            this.writeFloat(((Float)value).floatValue());
        } else if (type == Double.class) {
            this.writeByte((byte)4);
            this.writeDouble((Double)value);
        } else if (type == Boolean.class) {
            this.writeByte((byte)5);
            this.writeBoolean((Boolean)value);
        } else if (type == byte[].class) {
            this.writeByte((byte)6);
            this.writeVInt(((byte[])value).length);
            this.writeBytes((byte[])value);
        } else if (value instanceof List) {
            this.writeByte((byte)7);
            List list = (List)value;
            this.writeVInt(list.size());
            for (Object o : list) {
                this.writeGenericValue(o);
            }
        } else if (value instanceof Object[]) {
            this.writeByte((byte)8);
            Object[] list = (Object[])value;
            this.writeVInt(list.length);
            for (Object o : list) {
                this.writeGenericValue(o);
            }
        } else if (value instanceof Map) {
            if (value instanceof LinkedHashMap) {
                this.writeByte((byte)9);
            } else {
                this.writeByte((byte)10);
            }
            Map map = (Map)value;
            this.writeVInt(map.size());
            for (Map.Entry entry : map.entrySet()) {
                this.writeString((String)entry.getKey());
                this.writeGenericValue(entry.getValue());
            }
        } else if (type == Byte.class) {
            this.writeByte((byte)11);
            this.writeByte((Byte)value);
        } else if (type == Date.class) {
            this.writeByte((byte)12);
            this.writeLong(((Date)value).getTime());
        } else if (value instanceof ReadableInstant) {
            this.writeByte((byte)13);
            this.writeString(((ReadableInstant)value).getZone().getID());
            this.writeLong(((ReadableInstant)value).getMillis());
        } else if (value instanceof BytesReference) {
            this.writeByte((byte)14);
            this.writeBytesReference((BytesReference)value);
        } else if (value instanceof Text) {
            this.writeByte((byte)15);
            this.writeText((Text)value);
        } else if (type == Short.class) {
            this.writeByte((byte)16);
            this.writeShort((Short)value);
        } else if (type == int[].class) {
            this.writeByte((byte)17);
            this.writeIntArray((int[])value);
        } else if (type == long[].class) {
            this.writeByte((byte)18);
            this.writeLongArray((long[])value);
        } else if (type == float[].class) {
            this.writeByte((byte)19);
            this.writeFloatArray((float[])value);
        } else if (type == double[].class) {
            this.writeByte((byte)20);
            this.writeDoubleArray((double[])value);
        } else if (value instanceof BytesRef) {
            this.writeByte((byte)21);
            this.writeBytesRef((BytesRef)value);
        } else if (type == GeoPoint.class) {
            this.writeByte((byte)22);
            this.writeGeoPoint((GeoPoint)value);
        } else {
            throw new IOException("Can't write type [" + type + "]");
        }
    }

    public void writeIntArray(int[] values) throws IOException {
        this.writeVInt(values.length);
        for (int value : values) {
            this.writeInt(value);
        }
    }

    public void writeVIntArray(int[] values) throws IOException {
        this.writeVInt(values.length);
        for (int value : values) {
            this.writeVInt(value);
        }
    }

    public void writeLongArray(long[] values) throws IOException {
        this.writeVInt(values.length);
        for (long value : values) {
            this.writeLong(value);
        }
    }

    public void writeVLongArray(long[] values) throws IOException {
        this.writeVInt(values.length);
        for (long value : values) {
            this.writeVLong(value);
        }
    }

    public void writeFloatArray(float[] values) throws IOException {
        this.writeVInt(values.length);
        for (float value : values) {
            this.writeFloat(value);
        }
    }

    public void writeDoubleArray(double[] values) throws IOException {
        this.writeVInt(values.length);
        for (double value : values) {
            this.writeDouble(value);
        }
    }

    public void writeOptionalStreamable(@Nullable Streamable streamable) throws IOException {
        if (streamable != null) {
            this.writeBoolean(true);
            streamable.writeTo(this);
        } else {
            this.writeBoolean(false);
        }
    }

    public void writeThrowable(Throwable throwable) throws IOException {
        if (throwable == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            boolean writeCause = true;
            boolean writeMessage = true;
            if (throwable instanceof CorruptIndexException) {
                this.writeVInt(1);
                this.writeOptionalString(((CorruptIndexException)throwable).getOriginalMessage());
                this.writeOptionalString(((CorruptIndexException)throwable).getResourceDescription());
                writeMessage = false;
            } else if (throwable instanceof IndexFormatTooNewException) {
                this.writeVInt(2);
                this.writeOptionalString(((IndexFormatTooNewException)throwable).getResourceDescription());
                this.writeInt(((IndexFormatTooNewException)throwable).getVersion());
                this.writeInt(((IndexFormatTooNewException)throwable).getMinVersion());
                this.writeInt(((IndexFormatTooNewException)throwable).getMaxVersion());
                writeMessage = false;
                writeCause = false;
            } else if (throwable instanceof IndexFormatTooOldException) {
                this.writeVInt(3);
                IndexFormatTooOldException t = (IndexFormatTooOldException)throwable;
                this.writeOptionalString(t.getResourceDescription());
                if (t.getVersion() == null) {
                    this.writeBoolean(false);
                    this.writeOptionalString(t.getReason());
                } else {
                    this.writeBoolean(true);
                    this.writeInt(t.getVersion());
                    this.writeInt(t.getMinVersion());
                    this.writeInt(t.getMaxVersion());
                }
                writeMessage = false;
                writeCause = false;
            } else if (throwable instanceof NullPointerException) {
                this.writeVInt(4);
                writeCause = false;
            } else if (throwable instanceof NumberFormatException) {
                this.writeVInt(5);
                writeCause = false;
            } else if (throwable instanceof IllegalArgumentException) {
                this.writeVInt(6);
            } else if (throwable instanceof AlreadyClosedException) {
                this.writeVInt(7);
            } else if (throwable instanceof EOFException) {
                this.writeVInt(8);
                writeCause = false;
            } else if (throwable instanceof SecurityException) {
                this.writeVInt(9);
            } else if (throwable instanceof StringIndexOutOfBoundsException) {
                this.writeVInt(10);
                writeCause = false;
            } else if (throwable instanceof ArrayIndexOutOfBoundsException) {
                this.writeVInt(11);
                writeCause = false;
            } else if (throwable instanceof AssertionError) {
                this.writeVInt(12);
            } else if (throwable instanceof FileNotFoundException) {
                this.writeVInt(13);
                writeCause = false;
            } else if (throwable instanceof NoSuchFileException) {
                this.writeVInt(14);
                this.writeOptionalString(((NoSuchFileException)throwable).getFile());
                this.writeOptionalString(((NoSuchFileException)throwable).getOtherFile());
                this.writeOptionalString(((NoSuchFileException)throwable).getReason());
                writeCause = false;
            } else if (throwable instanceof OutOfMemoryError) {
                this.writeVInt(15);
                writeCause = false;
            } else if (throwable instanceof IllegalStateException) {
                this.writeVInt(16);
            } else if (throwable instanceof LockObtainFailedException) {
                this.writeVInt(17);
            } else if (throwable instanceof InterruptedException) {
                this.writeVInt(18);
                writeCause = false;
            } else {
                ElasticsearchException ex = throwable instanceof ElasticsearchException && ElasticsearchException.isRegistered(throwable.getClass()) ? (ElasticsearchException)throwable : new NotSerializableExceptionWrapper(throwable);
                this.writeVInt(0);
                this.writeVInt(ElasticsearchException.getId(ex.getClass()));
                ex.writeTo(this);
                return;
            }
            if (writeMessage) {
                this.writeOptionalString(throwable.getMessage());
            }
            if (writeCause) {
                this.writeThrowable(throwable.getCause());
            }
            ElasticsearchException.writeStackTraces(throwable, this);
        }
    }

    void writeNamedWriteable(NamedWriteable namedWriteable) throws IOException {
        this.writeString(namedWriteable.getWriteableName());
        namedWriteable.writeTo(this);
    }

    public void writeGeoPoint(GeoPoint geoPoint) throws IOException {
        this.writeDouble(geoPoint.lat());
        this.writeDouble(geoPoint.lon());
    }
}

