/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.termvectors;

import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.action.termvectors.TermVectorsRequest;
import org.elasticsearch.action.termvectors.TermVectorsResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestToXContentListener;

public class RestTermVectorsAction
extends BaseRestHandler {
    @Inject
    public RestTermVectorsAction(Settings settings, RestController controller, Client client) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_termvectors", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_termvectors", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/{id}/_termvectors", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/{id}/_termvectors", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_termvector", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_termvector", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/{id}/_termvector", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/{id}/_termvector", this);
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel, Client client) throws Exception {
        TermVectorsRequest termVectorsRequest = new TermVectorsRequest(request.param("index"), request.param("type"), request.param("id"));
        if (RestActions.hasBodyContent(request)) {
            try (XContentParser parser = XContentFactory.xContent(RestActions.guessBodyContentType(request)).createParser(RestActions.getRestContent(request));){
                TermVectorsRequest.parseRequest(termVectorsRequest, parser);
            }
        }
        RestTermVectorsAction.readURIParameters(termVectorsRequest, request);
        client.termVectors(termVectorsRequest, new RestToXContentListener<TermVectorsResponse>(channel));
    }

    public static void readURIParameters(TermVectorsRequest termVectorsRequest, RestRequest request) {
        String fields = request.param("fields");
        RestTermVectorsAction.addFieldStringsFromParameter(termVectorsRequest, fields);
        termVectorsRequest.offsets(request.paramAsBoolean("offsets", termVectorsRequest.offsets()));
        termVectorsRequest.positions(request.paramAsBoolean("positions", termVectorsRequest.positions()));
        termVectorsRequest.payloads(request.paramAsBoolean("payloads", termVectorsRequest.payloads()));
        termVectorsRequest.routing(request.param("routing"));
        termVectorsRequest.realtime(request.paramAsBoolean("realtime", null));
        termVectorsRequest.version(RestActions.parseVersion(request, termVectorsRequest.version()));
        termVectorsRequest.versionType(VersionType.fromString(request.param("version_type"), termVectorsRequest.versionType()));
        termVectorsRequest.parent(request.param("parent"));
        termVectorsRequest.preference(request.param("preference"));
        termVectorsRequest.termStatistics(request.paramAsBoolean("termStatistics", termVectorsRequest.termStatistics()));
        termVectorsRequest.termStatistics(request.paramAsBoolean("term_statistics", termVectorsRequest.termStatistics()));
        termVectorsRequest.fieldStatistics(request.paramAsBoolean("fieldStatistics", termVectorsRequest.fieldStatistics()));
        termVectorsRequest.fieldStatistics(request.paramAsBoolean("field_statistics", termVectorsRequest.fieldStatistics()));
        termVectorsRequest.dfs(request.paramAsBoolean("dfs", termVectorsRequest.dfs()));
    }

    public static void addFieldStringsFromParameter(TermVectorsRequest termVectorsRequest, String fields) {
        Set<String> selectedFields = termVectorsRequest.selectedFields();
        if (fields != null) {
            String[] paramFieldStrings;
            for (String field : paramFieldStrings = Strings.commaDelimitedListToStringArray(fields)) {
                if (selectedFields == null) {
                    selectedFields = new HashSet<String>();
                }
                if (selectedFields.contains(field)) continue;
                field = field.replaceAll("\\s", "");
                selectedFields.add(field);
            }
        }
        if (selectedFields != null) {
            termVectorsRequest.selectedFields(selectedFields.toArray(new String[selectedFields.size()]));
        }
    }
}

