/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import jxl.biff.IntegerHelper;
import jxl.biff.RecordData;
import jxl.biff.StringHelper;
import jxl.read.biff.Record;

public class SupbookRecord
extends RecordData {
    private Type type;
    private int numSheets;
    private String fileName;
    private String[] sheetNames;
    public static final Type INTERNAL = new Type();
    public static final Type EXTERNAL = new Type();
    public static final Type ADDIN = new Type();
    public static final Type LINK = new Type();
    public static final Type UNKNOWN = new Type();

    SupbookRecord(Record t) {
        super(t);
        byte[] data = this.getRecord().getData();
        this.type = data.length == 4 ? (data[2] == 1 && data[3] == 4 ? INTERNAL : (data[2] == 1 && data[3] == 58 ? ADDIN : UNKNOWN)) : (data[0] == 0 && data[1] == 0 ? LINK : EXTERNAL);
        if (this.type == INTERNAL) {
            this.numSheets = IntegerHelper.getInt(data[0], data[1]);
        }
        if (this.type == EXTERNAL) {
            this.readExternal(data);
        }
    }

    private void readExternal(byte[] data) {
        this.numSheets = IntegerHelper.getInt(data[0], data[1]);
        int ln = IntegerHelper.getInt(data[2], data[3]) - 1;
        int pos = 6;
        if (data[4] == 0) {
            this.fileName = StringHelper.getString(data, ln, pos);
            pos += ln;
        } else if (data[4] == 1) {
            this.fileName = StringHelper.getUnicodeString(data, ln, pos);
            pos += ln * 2;
        }
        this.sheetNames = new String[this.numSheets];
        int i = 0;
        while (i < this.sheetNames.length) {
            ln = IntegerHelper.getInt(data[pos], data[pos + 1]);
            if (data[pos + 2] == 0) {
                this.sheetNames[i] = StringHelper.getString(data, ln, pos + 3);
                pos += ln + 3;
            } else if (data[pos + 2] == 1) {
                this.sheetNames[i] = StringHelper.getUnicodeString(data, ln, pos + 3);
                pos += ln * 2 + 3;
            }
            ++i;
        }
    }

    public Type getType() {
        return this.type;
    }

    public int getNumberOfSheets() {
        return this.numSheets;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getSheetName(int i) {
        return this.sheetNames[i];
    }

    public byte[] getData() {
        return this.getRecord().getData();
    }

    private static class Type {
        private Type() {
        }
    }
}

