/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.biff.Fonts;
import jxl.biff.FormattingRecords;
import jxl.biff.IntegerHelper;
import jxl.read.biff.WorkbookParser;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.biff.BOFRecord;
import jxl.write.biff.BackupRecord;
import jxl.write.biff.BookboolRecord;
import jxl.write.biff.BoundsheetRecord;
import jxl.write.biff.CodepageRecord;
import jxl.write.biff.CountryRecord;
import jxl.write.biff.DSFRecord;
import jxl.write.biff.DateRecord;
import jxl.write.biff.EOFRecord;
import jxl.write.biff.ExternalSheetRecord;
import jxl.write.biff.File;
import jxl.write.biff.FunctionGroupCountRecord;
import jxl.write.biff.HideobjRecord;
import jxl.write.biff.InterfaceEndRecord;
import jxl.write.biff.InterfaceHeaderRecord;
import jxl.write.biff.MMSRecord;
import jxl.write.biff.MsoDrawingGroupRecord;
import jxl.write.biff.NameRecord;
import jxl.write.biff.NineteenFourRecord;
import jxl.write.biff.PasswordRecord;
import jxl.write.biff.PrecisionRecord;
import jxl.write.biff.Prot4RevPassRecord;
import jxl.write.biff.Prot4RevRecord;
import jxl.write.biff.ProtectRecord;
import jxl.write.biff.RefreshAllRecord;
import jxl.write.biff.SharedStrings;
import jxl.write.biff.SupbookRecord;
import jxl.write.biff.TabIdRecord;
import jxl.write.biff.UsesElfsRecord;
import jxl.write.biff.Window1Record;
import jxl.write.biff.WindowProtectRecord;
import jxl.write.biff.WritableFonts;
import jxl.write.biff.WritableFormattingRecords;
import jxl.write.biff.WritableSheetImpl;
import jxl.write.biff.WriteAccessRecord;

public class WritableWorkbookImpl
extends WritableWorkbook {
    private FormattingRecords formatRecords;
    private File outputFile;
    private ArrayList sheets;
    private Fonts fonts;
    private ExternalSheetRecord externSheet;
    private MsoDrawingGroupRecord msoDrawingGroup;
    private SupbookRecord[] supbooks;
    private NameRecord[] names;
    private SharedStrings sharedStrings;
    private boolean closeStream;
    private boolean wbProtected;
    private WorkbookSettings settings;

    public WritableWorkbookImpl(OutputStream os, boolean cs, WorkbookSettings ws) throws IOException {
        this.outputFile = new File(os, ws);
        this.sheets = new ArrayList();
        this.sharedStrings = new SharedStrings();
        this.closeStream = cs;
        this.wbProtected = false;
        this.settings = ws;
        WritableWorkbook.ARIAL_10_PT.uninitialize();
        WritableWorkbook.HYPERLINK_FONT.uninitialize();
        WritableWorkbook.NORMAL_STYLE.uninitialize();
        WritableWorkbook.HYPERLINK_STYLE.uninitialize();
        DateRecord.defaultDateFormat.uninitialize();
        WritableFonts wf = new WritableFonts();
        this.fonts = wf;
        WritableFormattingRecords wfr = new WritableFormattingRecords(this.fonts);
        this.formatRecords = wfr;
    }

    public WritableWorkbookImpl(OutputStream os, Workbook w, boolean cs, WorkbookSettings ws) throws IOException {
        int i;
        WorkbookParser wp = (WorkbookParser)w;
        WritableWorkbook.ARIAL_10_PT.uninitialize();
        WritableWorkbook.HYPERLINK_FONT.uninitialize();
        WritableWorkbook.NORMAL_STYLE.uninitialize();
        WritableWorkbook.HYPERLINK_STYLE.uninitialize();
        DateRecord.defaultDateFormat.uninitialize();
        this.outputFile = new File(os, ws);
        this.closeStream = cs;
        this.sheets = new ArrayList();
        this.sharedStrings = new SharedStrings();
        this.fonts = wp.getFonts();
        this.formatRecords = wp.getFormattingRecords();
        this.wbProtected = false;
        this.settings = ws;
        if (wp.getExternalSheetRecord() != null) {
            this.externSheet = new ExternalSheetRecord(wp.getExternalSheetRecord());
            jxl.read.biff.SupbookRecord[] readsr = wp.getSupbookRecords();
            this.supbooks = new SupbookRecord[readsr.length];
            i = 0;
            while (i < this.supbooks.length) {
                this.supbooks[i] = new SupbookRecord(readsr[i]);
                ++i;
            }
        }
        if (wp.getMsoDrawingGroupRecord() != null) {
            this.msoDrawingGroup = new MsoDrawingGroupRecord(wp.getMsoDrawingGroupRecord());
        }
        if (!this.settings.getNamesDisabled()) {
            jxl.read.biff.NameRecord[] na = wp.getNameRecords();
            this.names = new NameRecord[na.length];
            i = 0;
            while (i < na.length) {
                this.names[i] = new NameRecord(na[i]);
                ++i;
            }
        }
        this.copyWorkbook(w);
    }

    public WritableSheet[] getSheets() {
        WritableSheet[] sheetArray = new WritableSheet[this.getNumberOfSheets()];
        int i = 0;
        while (i < this.getNumberOfSheets()) {
            sheetArray[i] = this.getSheet(i);
            ++i;
        }
        return sheetArray;
    }

    public WritableSheet getSheet(int index) {
        return (WritableSheet)this.sheets.get(index);
    }

    public WritableSheet getSheet(String name) {
        boolean found = false;
        Iterator i = this.sheets.iterator();
        WritableSheet s = null;
        while (i.hasNext() && !found) {
            s = (WritableSheet)i.next();
            if (!s.getName().equals(name)) continue;
            found = true;
        }
        return found ? s : null;
    }

    public int getNumberOfSheets() {
        return this.sheets.size();
    }

    public void close() throws IOException {
        this.outputFile.close(this.closeStream);
    }

    public WritableSheet createSheet(String name, int index) {
        WritableSheetImpl w = new WritableSheetImpl(name, this.outputFile, this.formatRecords, this.sharedStrings, this.settings);
        if (index <= 0) {
            this.sheets.add(0, w);
        } else if (index > this.sheets.size()) {
            this.sheets.add(w);
        } else {
            this.sheets.add(index, w);
        }
        return w;
    }

    public void removeSheet(int index) {
        if (index <= 0) {
            this.sheets.remove(0);
        } else if (index >= this.sheets.size()) {
            this.sheets.remove(this.sheets.size() - 1);
        } else {
            this.sheets.remove(index);
        }
    }

    public void write() throws IOException {
        int i;
        WritableSheetImpl wsi = null;
        int i2 = 0;
        while (i2 < this.getNumberOfSheets()) {
            wsi = (WritableSheetImpl)this.getSheet(i2);
            wsi.checkMergedBorders();
            ++i2;
        }
        BOFRecord bof = new BOFRecord(BOFRecord.workbookGlobals);
        this.outputFile.write(bof);
        InterfaceHeaderRecord ihr = new InterfaceHeaderRecord();
        this.outputFile.write(ihr);
        MMSRecord mms = new MMSRecord(0, 0);
        this.outputFile.write(mms);
        InterfaceEndRecord ier = new InterfaceEndRecord();
        this.outputFile.write(ier);
        WriteAccessRecord wr = new WriteAccessRecord();
        this.outputFile.write(wr);
        CodepageRecord cp = new CodepageRecord();
        this.outputFile.write(cp);
        DSFRecord dsf = new DSFRecord();
        this.outputFile.write(dsf);
        TabIdRecord tabid = new TabIdRecord(this.getNumberOfSheets());
        this.outputFile.write(tabid);
        FunctionGroupCountRecord fgcr = new FunctionGroupCountRecord();
        this.outputFile.write(fgcr);
        WindowProtectRecord wpr = new WindowProtectRecord(false);
        this.outputFile.write(wpr);
        ProtectRecord pr = new ProtectRecord(this.wbProtected);
        this.outputFile.write(pr);
        PasswordRecord pw = new PasswordRecord(null);
        this.outputFile.write(pw);
        Prot4RevRecord p4r = new Prot4RevRecord(false);
        this.outputFile.write(p4r);
        Prot4RevPassRecord p4rp = new Prot4RevPassRecord();
        this.outputFile.write(p4rp);
        Window1Record w1r = new Window1Record();
        this.outputFile.write(w1r);
        BackupRecord bkr = new BackupRecord(false);
        this.outputFile.write(bkr);
        HideobjRecord ho = new HideobjRecord(false);
        this.outputFile.write(ho);
        NineteenFourRecord nf = new NineteenFourRecord(false);
        this.outputFile.write(nf);
        PrecisionRecord pc = new PrecisionRecord(false);
        this.outputFile.write(pc);
        RefreshAllRecord rar = new RefreshAllRecord(false);
        this.outputFile.write(rar);
        BookboolRecord bb = new BookboolRecord(true);
        this.outputFile.write(bb);
        this.fonts.write(this.outputFile);
        this.formatRecords.write(this.outputFile);
        UsesElfsRecord uer = new UsesElfsRecord();
        this.outputFile.write(uer);
        int[] boundsheetPos = new int[this.getNumberOfSheets()];
        WritableSheet sheet = null;
        int i3 = 0;
        while (i3 < this.getNumberOfSheets()) {
            boundsheetPos[i3] = this.outputFile.getPos();
            sheet = this.getSheet(i3);
            BoundsheetRecord br = new BoundsheetRecord(sheet.getName(), sheet.isHidden());
            this.outputFile.write(br);
            ++i3;
        }
        CountryRecord cr = new CountryRecord();
        this.outputFile.write(cr);
        if (this.externSheet != null) {
            i = 0;
            while (i < this.supbooks.length) {
                this.outputFile.write(this.supbooks[i]);
                ++i;
            }
            this.outputFile.write(this.externSheet);
        }
        if (this.names != null) {
            i = 0;
            while (i < this.names.length) {
                this.outputFile.write(this.names[i]);
                ++i;
            }
        }
        if (this.msoDrawingGroup != null) {
            this.outputFile.write(this.msoDrawingGroup);
        }
        this.sharedStrings.write(this.outputFile);
        EOFRecord eof = new EOFRecord();
        this.outputFile.write(eof);
        WritableSheetImpl wsheet = null;
        int i4 = 0;
        while (i4 < this.getNumberOfSheets()) {
            this.outputFile.setData(IntegerHelper.getFourBytes(this.outputFile.getPos()), boundsheetPos[i4] + 4);
            wsheet = (WritableSheetImpl)this.getSheet(i4);
            if (i4 == 0) {
                wsheet.setSelected();
            }
            wsheet.write();
            ++i4;
        }
    }

    private void copyWorkbook(Workbook w) {
        int numSheets = w.getNumberOfSheets();
        this.wbProtected = w.isProtected();
        Sheet s = null;
        WritableSheetImpl ws = null;
        int i = 0;
        while (i < numSheets) {
            s = w.getSheet(i);
            ws = (WritableSheetImpl)this.createSheet(s.getName(), i);
            ws.copy(s);
            ++i;
        }
    }

    public void copySheet(int s, String name, int index) {
        WritableSheet sheet = this.getSheet(s);
        WritableSheetImpl ws = (WritableSheetImpl)this.createSheet(name, index);
        ws.copy(sheet);
    }

    public void copySheet(String s, String name, int index) {
        WritableSheet sheet = this.getSheet(s);
        WritableSheetImpl ws = (WritableSheetImpl)this.createSheet(name, index);
        ws.copy(sheet);
    }

    public void setProtected(boolean prot) {
        this.wbProtected = prot;
    }
}

