/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.RowidBinder;

class LittleEndianRowidBinder
extends RowidBinder {
    LittleEndianRowidBinder() {
    }

    void bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues) {
        byte[][] datums = stmt.parameterDatum[rank];
        byte[] value = datums[bindPosition];
        if (clearPriorBindValues) {
            datums[bindPosition] = null;
        }
        if (value == null) {
            bindIndicators[indoffset] = -1;
        } else {
            bindIndicators[indoffset] = 0;
            int l = value.length;
            System.arraycopy(value, 0, bindBytes, byteoffset + 2, l);
            bindBytes[byteoffset + 1] = (byte)(l >> 8);
            bindBytes[byteoffset] = (byte)(l & 0xFF);
            bindIndicators[lenoffset] = (short)(l + 2);
        }
    }
}

