/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.logging.Level;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.BaseResultSet;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;

class OracleReturnResultSet
extends BaseResultSet {
    OracleStatement statement;
    boolean closed;
    Accessor[] returnAccessors;

    OracleReturnResultSet(OracleStatement s) throws SQLException {
        this.statement = s;
        this.closed = false;
        this.returnAccessors = new Accessor[s.numReturnParams];
        int j = 0;
        for (int i = 0; i < s.numberOfBindPositions; ++i) {
            Accessor accessor = s.returnParamAccessors[i];
            if (accessor == null) continue;
            this.returnAccessors[j++] = accessor;
        }
    }

    public synchronized boolean next() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.next(): closed=" + this.closed, this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            return false;
        }
        if (!this.statement.returnParamsFetched) {
            this.statement.fetchDmlReturnParams();
            this.statement.setupReturnParamAccessors();
        }
        ++this.statement.currentRow;
        ++this.statement.totalRowsVisited;
        return this.statement.currentRow < this.statement.rowsDmlReturned;
    }

    public synchronized void close() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.close()", this);
            OracleLog.recursiveTrace = false;
        }
        this.closed = true;
        this.statement.returnResultSet = null;
        this.statement.numReturnParams = 0;
        this.statement.totalRowsVisited = 0;
        this.statement.currentRow = -1;
        this.statement.returnParamsFetched = false;
        this.statement.rowsDmlReturned = 0;
        this.statement.returnParamBytes = null;
        this.statement.returnParamChars = null;
        this.statement.returnParamIndicators = null;
    }

    public synchronized boolean wasNull() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.wasNull()", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (this.statement.currentRow == -1 || this.statement.lastIndex == 0) {
            DatabaseError.throwSqlException(24);
        }
        return this.returnAccessors[this.statement.lastIndex - 1].isNull(this.statement.currentRow);
    }

    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.getMetaData()", this);
            OracleLog.recursiveTrace = false;
        }
        if (!this.statement.isAutoGeneratedKey) {
            DatabaseError.throwSqlException(23);
        }
        if (this.closed) {
            DatabaseError.throwSqlException(10);
        }
        if (this.statement.closed) {
            DatabaseError.throwSqlException(9);
        }
        AutoKeyInfo info = this.statement.autoKeyInfo;
        info.statement = this.statement;
        info.connection = this.statement.connection;
        info.initMetaData(this);
        return info;
    }

    public synchronized Statement getStatement() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.getStatement()", this);
            OracleLog.recursiveTrace = false;
        }
        return this.statement;
    }

    public synchronized String getString(int columnIndex) throws SQLException {
        int currentRow;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.getString(columnIndex=" + columnIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((currentRow = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = columnIndex;
        return this.returnAccessors[columnIndex - 1].getString(currentRow);
    }

    public synchronized boolean getBoolean(int columnIndex) throws SQLException {
        int currentRow;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.getBoolean(columnIndex=" + columnIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((currentRow = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = columnIndex;
        return this.returnAccessors[columnIndex - 1].getBoolean(currentRow);
    }

    public synchronized byte getByte(int columnIndex) throws SQLException {
        int currentRow;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.getByte(columnIndex=" + columnIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((currentRow = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = columnIndex;
        return this.returnAccessors[columnIndex - 1].getByte(currentRow);
    }

    public synchronized short getShort(int columnIndex) throws SQLException {
        int currentRow;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.getShort(columnIndex=" + columnIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((currentRow = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = columnIndex;
        return this.returnAccessors[columnIndex - 1].getShort(currentRow);
    }

    public synchronized int getInt(int columnIndex) throws SQLException {
        int currentRow;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.getInt(columnIndex=" + columnIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((currentRow = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = columnIndex;
        return this.returnAccessors[columnIndex - 1].getInt(currentRow);
    }

    public synchronized long getLong(int columnIndex) throws SQLException {
        int currentRow;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.getLong(columnIndex=" + columnIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((currentRow = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = columnIndex;
        return this.returnAccessors[columnIndex - 1].getLong(currentRow);
    }

    public synchronized float getFloat(int columnIndex) throws SQLException {
        int currentRow;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.getFloat(columnIndex=" + columnIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((currentRow = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = columnIndex;
        return this.returnAccessors[columnIndex - 1].getFloat(currentRow);
    }

    public synchronized double getDouble(int columnIndex) throws SQLException {
        int currentRow;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.getDouble(columnIndex=" + columnIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((currentRow = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = columnIndex;
        return this.returnAccessors[columnIndex - 1].getDouble(currentRow);
    }

    public synchronized BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        int currentRow;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.getBigDecimal(columnIndex=" + columnIndex + ", scale=" + scale + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((currentRow = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = columnIndex;
        return this.returnAccessors[columnIndex - 1].getBigDecimal(currentRow, scale);
    }

    public synchronized byte[] getBytes(int columnIndex) throws SQLException {
        int currentRow;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.getBytes(columnIndex=" + columnIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((currentRow = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = columnIndex;
        return this.returnAccessors[columnIndex - 1].getBytes(currentRow);
    }

    public synchronized Date getDate(int columnIndex) throws SQLException {
        int currentRow;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.getDate(columnIndex=" + columnIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((currentRow = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = columnIndex;
        return this.returnAccessors[columnIndex - 1].getDate(currentRow);
    }

    public synchronized Time getTime(int columnIndex) throws SQLException {
        int currentRow;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.getTime(columnIndex=" + columnIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((currentRow = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = columnIndex;
        return this.returnAccessors[columnIndex - 1].getTime(currentRow);
    }

    public synchronized Timestamp getTimestamp(int columnIndex) throws SQLException {
        int currentRow;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.getTimestamp(columnIndex=" + columnIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((currentRow = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = columnIndex;
        return this.returnAccessors[columnIndex - 1].getTimestamp(currentRow);
    }

    public synchronized InputStream getAsciiStream(int columnIndex) throws SQLException {
        DatabaseError.throwSqlException(23);
        return null;
    }

    public synchronized InputStream getUnicodeStream(int columnIndex) throws SQLException {
        DatabaseError.throwSqlException(23);
        return null;
    }

    public synchronized InputStream getBinaryStream(int columnIndex) throws SQLException {
        DatabaseError.throwSqlException(23);
        return null;
    }

    public synchronized Object getObject(int columnIndex) throws SQLException {
        int currentRow;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.getObject(columnIndex=" + columnIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((currentRow = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = columnIndex;
        return this.returnAccessors[columnIndex - 1].getObject(currentRow);
    }

    public synchronized ResultSet getCursor(int columnIndex) throws SQLException {
        DatabaseError.throwSqlException(23);
        return null;
    }

    public synchronized Datum getOracleObject(int columnIndex) throws SQLException {
        int currentRow;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.getOracleObject(columnIndex=" + columnIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((currentRow = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = columnIndex;
        return this.returnAccessors[columnIndex - 1].getOracleObject(currentRow);
    }

    public synchronized ROWID getROWID(int columnIndex) throws SQLException {
        int currentRow;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.getROWID(columnIndex=" + columnIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((currentRow = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = columnIndex;
        return this.returnAccessors[columnIndex - 1].getROWID(currentRow);
    }

    public synchronized NUMBER getNUMBER(int columnIndex) throws SQLException {
        int currentRow;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.getNUMBER(columnIndex=" + columnIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((currentRow = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = columnIndex;
        return this.returnAccessors[columnIndex - 1].getNUMBER(currentRow);
    }

    public synchronized DATE getDATE(int columnIndex) throws SQLException {
        int currentRow;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.getDATE(columnIndex=" + columnIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((currentRow = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = columnIndex;
        return this.returnAccessors[columnIndex - 1].getDATE(currentRow);
    }

    public synchronized ARRAY getARRAY(int columnIndex) throws SQLException {
        int currentRow;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.getARRAY(columnIndex=" + columnIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((currentRow = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = columnIndex;
        return this.returnAccessors[columnIndex - 1].getARRAY(currentRow);
    }

    public synchronized STRUCT getSTRUCT(int columnIndex) throws SQLException {
        int currentRow;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.getSTRUCT(columnIndex=" + columnIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((currentRow = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = columnIndex;
        return this.returnAccessors[columnIndex - 1].getSTRUCT(currentRow);
    }

    public synchronized OPAQUE getOPAQUE(int columnIndex) throws SQLException {
        DatabaseError.throwSqlException(23);
        return null;
    }

    public synchronized REF getREF(int columnIndex) throws SQLException {
        int currentRow;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.getREF(columnIndex=" + columnIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((currentRow = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = columnIndex;
        return this.returnAccessors[columnIndex - 1].getREF(currentRow);
    }

    public synchronized CHAR getCHAR(int columnIndex) throws SQLException {
        int currentRow;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.getCHAR(columnIndex=" + columnIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((currentRow = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = columnIndex;
        return this.returnAccessors[columnIndex - 1].getCHAR(currentRow);
    }

    public synchronized RAW getRAW(int columnIndex) throws SQLException {
        int currentRow;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.getRAW(columnIndex=" + columnIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((currentRow = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = columnIndex;
        return this.returnAccessors[columnIndex - 1].getRAW(currentRow);
    }

    public synchronized BLOB getBLOB(int columnIndex) throws SQLException {
        int currentRow;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.getBLOB(columnIndex=" + columnIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((currentRow = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = columnIndex;
        return this.returnAccessors[columnIndex - 1].getBLOB(currentRow);
    }

    public synchronized CLOB getCLOB(int columnIndex) throws SQLException {
        int currentRow;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.getCLOB(columnIndex=" + columnIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((currentRow = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = columnIndex;
        return this.returnAccessors[columnIndex - 1].getCLOB(currentRow);
    }

    public synchronized BFILE getBFILE(int columnIndex) throws SQLException {
        int currentRow;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.getBFILE(columnIndex=" + columnIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((currentRow = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = columnIndex;
        return this.returnAccessors[columnIndex - 1].getBFILE(currentRow);
    }

    public synchronized BFILE getBfile(int columnIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.getBfile(columnIndex=" + columnIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        return this.getBFILE(columnIndex);
    }

    public synchronized CustomDatum getCustomDatum(int columnIndex, CustomDatumFactory factory) throws SQLException {
        DatabaseError.throwSqlException(23);
        return null;
    }

    public synchronized ORAData getORAData(int columnIndex, ORADataFactory factory) throws SQLException {
        int currentRow;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.getORAData(columnIndex=" + columnIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((currentRow = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = columnIndex;
        return this.returnAccessors[columnIndex - 1].getORAData(currentRow, factory);
    }

    public synchronized Object getObject(int columnIndex, Map map) throws SQLException {
        int currentRow;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.getObject(columnIndex=" + columnIndex + ", map=" + map + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((currentRow = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = columnIndex;
        return this.returnAccessors[columnIndex - 1].getObject(currentRow, map);
    }

    public synchronized Ref getRef(int columnIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.getRef(columnIndex=" + columnIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        return this.getREF(columnIndex);
    }

    public synchronized Blob getBlob(int columnIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.getBlob(columnIndex=" + columnIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        return this.getBLOB(columnIndex);
    }

    public synchronized Clob getClob(int columnIndex) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.getClob(columnIndex=" + columnIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        return this.getCLOB(columnIndex);
    }

    public synchronized Array getArray(int columnIndex) throws SQLException {
        DatabaseError.throwSqlException(23);
        return null;
    }

    public synchronized Reader getCharacterStream(int columnIndex) throws SQLException {
        DatabaseError.throwSqlException(23);
        return null;
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        int currentRow;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.getBigDecimal(columnIndex=" + columnIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((currentRow = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = columnIndex;
        return this.returnAccessors[columnIndex - 1].getBigDecimal(currentRow);
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        int currentRow;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.getDate(columnIndex=" + columnIndex + ", cal=" + cal + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((currentRow = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = columnIndex;
        return this.returnAccessors[columnIndex - 1].getDate(currentRow, cal);
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        int currentRow;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.getTime(columnIndex=" + columnIndex + ", cal=" + cal + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((currentRow = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = columnIndex;
        return this.returnAccessors[columnIndex - 1].getTime(currentRow, cal);
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        int currentRow;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.getTimestamp(columnIndex=" + columnIndex + ", cal=" + cal + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((currentRow = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = columnIndex;
        return this.returnAccessors[columnIndex - 1].getTimestamp(currentRow, cal);
    }

    public INTERVALYM getINTERVALYM(int columnIndex) throws SQLException {
        int currentRow;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.getINTERVALYM(columnIndex=" + columnIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((currentRow = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = columnIndex;
        return this.returnAccessors[columnIndex - 1].getINTERVALYM(currentRow);
    }

    public INTERVALDS getINTERVALDS(int columnIndex) throws SQLException {
        int currentRow;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.getINTERVALDS(columnIndex=" + columnIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((currentRow = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = columnIndex;
        return this.returnAccessors[columnIndex - 1].getINTERVALDS(currentRow);
    }

    public TIMESTAMP getTIMESTAMP(int columnIndex) throws SQLException {
        int currentRow;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.getTIMESTAMP(columnIndex=" + columnIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((currentRow = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = columnIndex;
        return this.returnAccessors[columnIndex - 1].getTIMESTAMP(currentRow);
    }

    public TIMESTAMPLTZ getTIMESTAMPLTZ(int columnIndex) throws SQLException {
        int currentRow;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.getTIMESTAMPLTZ(columnIndex=" + columnIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((currentRow = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = columnIndex;
        return this.returnAccessors[columnIndex - 1].getTIMESTAMPLTZ(currentRow);
    }

    public synchronized URL getURL(int columnIndex) throws SQLException {
        int currentRow;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleReturnResultSet.getURL(columnIndex=" + columnIndex + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.closed) {
            DatabaseError.throwSqlException(11);
        }
        if (columnIndex <= 0 || columnIndex > this.statement.numReturnParams) {
            DatabaseError.throwSqlException(3);
        }
        if ((currentRow = this.statement.currentRow) < 0) {
            DatabaseError.throwSqlException(14);
        }
        this.statement.lastIndex = columnIndex;
        return this.returnAccessors[columnIndex - 1].getURL(currentRow);
    }

    public boolean isBeforeFirst() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OracleReturnResultSet.isBeforeFirst: return: " + (!this.isEmptyResultSet() && this.statement.currentRow == -1 && !this.closed), this);
            OracleLog.recursiveTrace = false;
        }
        return !this.isEmptyResultSet() && this.statement.currentRow == -1 && !this.closed;
    }

    public boolean isAfterLast() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OracleReturnResultSet.isAfterLast: return: " + (!this.isEmptyResultSet() && this.closed), this);
            OracleLog.recursiveTrace = false;
        }
        return !this.isEmptyResultSet() && this.closed;
    }

    public boolean isFirst() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OracleReturnResultSet.isFirst: return: " + (this.getRow() == 1), this);
            OracleLog.recursiveTrace = false;
        }
        return this.getRow() == 1;
    }

    public boolean isLast() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OracleReturnResultSet.isLast()", this);
            OracleLog.recursiveTrace = false;
        }
        return this.getRow() == this.statement.rowsDmlReturned;
    }

    public int getRow() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OracleReturnResultSet.getRow: return: " + this.statement.totalRowsVisited, this);
            OracleLog.recursiveTrace = false;
        }
        return this.statement.totalRowsVisited;
    }

    public synchronized int findColumn(String columnName) throws SQLException {
        DatabaseError.throwSqlException(23);
        return -1;
    }

    public void setFetchSize(int rows) throws SQLException {
        DatabaseError.throwSqlException(23);
    }

    public int getFetchSize() throws SQLException {
        DatabaseError.throwSqlException(23);
        return -1;
    }

    boolean isEmptyResultSet() {
        return this.statement.rowsDmlReturned == 0;
    }
}

