/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Level;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.OracleTimeout;
import oracle.jdbc.driver.OracleTimeoutPollingThread;

class OracleTimeoutThreadPerVM
extends OracleTimeout {
    private static final OracleTimeoutPollingThread watchdog = new OracleTimeoutPollingThread();
    private OracleStatement statement;
    private long interruptAfter;
    private String name;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:30:52_PDT_2005";

    OracleTimeoutThreadPerVM(String name) {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OracleTimeoutThreadPerVM(" + name + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.name = name;
        this.interruptAfter = Long.MAX_VALUE;
        watchdog.addTimeout(this);
    }

    void close() {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OracleTimeoutThreadPerVM.close<" + this.name + ">()", this);
            OracleLog.recursiveTrace = false;
        }
        watchdog.removeTimeout(this);
    }

    synchronized void setTimeout(long milliseconds, OracleStatement stmt) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OracleTimeoutThreadPerVM.setTimeout<" + this.name + ">(" + milliseconds + ", " + stmt + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.interruptAfter != Long.MAX_VALUE) {
            DatabaseError.throwSqlException(131);
        }
        this.statement = stmt;
        this.interruptAfter = System.currentTimeMillis() + milliseconds;
    }

    synchronized void cancelTimeout() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OracleTimeoutThreadPerVM.cancelTimeout<" + this.name + ">()", this);
            OracleLog.recursiveTrace = false;
        }
        this.statement = null;
        this.interruptAfter = Long.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void interruptIfAppropriate(long now) {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINER, "OracleTimeoutThreadPerVM.interruptIfAppropriate<" + this.name + ">(" + now + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (now > this.interruptAfter) {
            OracleTimeoutThreadPerVM oracleTimeoutThreadPerVM = this;
            synchronized (oracleTimeoutThreadPerVM) {
                if (now > this.interruptAfter) {
                    block11: {
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleLog.driverLogger.log(Level.SEVERE, "OracleTimeoutThreadPerVM.interruptIfAppropriate<" + this.name + ">:INTERRUPTING", this);
                            OracleLog.recursiveTrace = false;
                        }
                        if (this.statement.connection.spawnNewThreadToCancel) {
                            final OracleStatement s = this.statement;
                            Thread t = new Thread(new Runnable(){

                                public void run() {
                                    block2: {
                                        try {
                                            s.cancel();
                                        }
                                        catch (Throwable e) {
                                            if (!TRACE || OracleLog.recursiveTrace) break block2;
                                            OracleLog.recursiveTrace = true;
                                            OracleLog.driverLogger.log(Level.SEVERE, "OracleTimeoutThreadPerVM.interruptIfAppropriate(spawned thread) failed: " + e, s);
                                            OracleLog.recursiveTrace = false;
                                        }
                                    }
                                }
                            });
                            t.setName("interruptIfAppropriate_" + this);
                            t.setDaemon(true);
                            t.setPriority(10);
                            t.start();
                        } else {
                            try {
                                this.statement.cancel();
                            }
                            catch (Throwable e) {
                                if (!TRACE || OracleLog.recursiveTrace) break block11;
                                OracleLog.recursiveTrace = true;
                                OracleLog.driverLogger.log(Level.SEVERE, "OracleTimeoutThreadPerVM.interruptIfAppropriate failed: " + e, this.statement);
                                OracleLog.recursiveTrace = false;
                            }
                        }
                    }
                    this.statement = null;
                    this.interruptAfter = Long.MAX_VALUE;
                }
            }
        }
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleTimeoutThreadPerVM"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

