/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Level;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.driver.ScrollableResultSet;
import oracle.jdbc.driver.SensitiveScrollableResultSet;
import oracle.jdbc.driver.UpdatableResultSet;

class ResultSetUtil {
    static final int[][] allRsetTypes = new int[][]{{0, 0}, {1003, 1007}, {1003, 1008}, {1004, 1007}, {1004, 1008}, {1005, 1007}, {1005, 1008}};
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:30:52_PDT_2005";

    ResultSetUtil() {
    }

    static OracleResultSet createScrollResultSet(ScrollRsetStatement owner, OracleResultSet referencedRset, int rsetType) throws SQLException {
        switch (rsetType) {
            case 1: {
                return referencedRset;
            }
            case 2: {
                return new UpdatableResultSet(owner, (OracleResultSetImpl)referencedRset, ResultSetUtil.getScrollType(rsetType), ResultSetUtil.getUpdateConcurrency(rsetType));
            }
            case 3: {
                return new ScrollableResultSet(owner, (OracleResultSetImpl)referencedRset, ResultSetUtil.getScrollType(rsetType), ResultSetUtil.getUpdateConcurrency(rsetType));
            }
            case 4: {
                ScrollableResultSet _rset = new ScrollableResultSet(owner, (OracleResultSetImpl)referencedRset, ResultSetUtil.getScrollType(rsetType), ResultSetUtil.getUpdateConcurrency(rsetType));
                return new UpdatableResultSet(owner, _rset, ResultSetUtil.getScrollType(rsetType), ResultSetUtil.getUpdateConcurrency(rsetType));
            }
            case 5: {
                return new SensitiveScrollableResultSet(owner, (OracleResultSetImpl)referencedRset, ResultSetUtil.getScrollType(rsetType), ResultSetUtil.getUpdateConcurrency(rsetType));
            }
            case 6: {
                SensitiveScrollableResultSet _rset1 = new SensitiveScrollableResultSet(owner, (OracleResultSetImpl)referencedRset, ResultSetUtil.getScrollType(rsetType), ResultSetUtil.getUpdateConcurrency(rsetType));
                return new UpdatableResultSet(owner, _rset1, ResultSetUtil.getScrollType(rsetType), ResultSetUtil.getUpdateConcurrency(rsetType));
            }
        }
        DatabaseError.throwSqlException(23, null);
        return null;
    }

    static int getScrollType(int typeCode) {
        return allRsetTypes[typeCode][0];
    }

    static int getUpdateConcurrency(int typeCode) {
        return allRsetTypes[typeCode][1];
    }

    static int getRsetTypeCode(int scrollType, int updateConcurrency) throws SQLException {
        for (int i = 0; i < allRsetTypes.length; ++i) {
            if (allRsetTypes[i][0] != scrollType || allRsetTypes[i][1] != updateConcurrency) continue;
            return i;
        }
        DatabaseError.throwSqlException(68);
        return 0;
    }

    static boolean needIdentifier(int typeCode) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "ResultSetUtil.needIdentifier(typeCode=" + typeCode + "): return: " + (typeCode != 1 && typeCode != 3));
            OracleLog.recursiveTrace = false;
        }
        return typeCode != 1 && typeCode != 3;
    }

    static boolean needIdentifier(int type, int concur) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "ResultSetUtil.needIdentifier(type=" + type + ", concur=" + concur + "): return: " + ResultSetUtil.needIdentifier(ResultSetUtil.getRsetTypeCode(type, concur)));
            OracleLog.recursiveTrace = false;
        }
        return ResultSetUtil.needIdentifier(ResultSetUtil.getRsetTypeCode(type, concur));
    }

    static boolean needCache(int typeCode) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "ResultSetUtil.needCache(typeCode=" + typeCode + "): return: " + (typeCode >= 3));
            OracleLog.recursiveTrace = false;
        }
        return typeCode >= 3;
    }

    static boolean needCache(int type, int concur) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "ResultSetUtil.needCache(type=" + type + ", concur=" + concur + "); return: " + ResultSetUtil.needCache(ResultSetUtil.getRsetTypeCode(type, concur)));
            OracleLog.recursiveTrace = false;
        }
        return ResultSetUtil.needCache(ResultSetUtil.getRsetTypeCode(type, concur));
    }

    static boolean supportRefreshRow(int typeCode) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "ResultSetUtil.supportRefreshRow(typeCode=" + typeCode + "): return: " + (typeCode >= 4));
            OracleLog.recursiveTrace = false;
        }
        return typeCode >= 4;
    }

    static boolean supportRefreshRow(int type, int concur) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "ResultSetUtil.supportRefreshRow(type=" + type + ", concur=" + concur + "): return: " + ResultSetUtil.supportRefreshRow(ResultSetUtil.getRsetTypeCode(type, concur)));
            OracleLog.recursiveTrace = false;
        }
        return ResultSetUtil.supportRefreshRow(ResultSetUtil.getRsetTypeCode(type, concur));
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.ResultSetUtil"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

