/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.pool.OraclePooledConnection;

public class OracleConnectionPoolDataSource
extends OracleDataSource
implements ConnectionPoolDataSource {
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:30:55_PDT_2005";

    public OracleConnectionPoolDataSource() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.poolLogger.log(Level.FINE, "OracleConnectionPoolDataSource.OracleConnectionPoolDataSource()", this);
            OracleLog.recursiveTrace = false;
        }
        this.dataSourceName = "OracleConnectionPoolDataSource";
        this.isOracleDataSource = false;
        this.connCachingEnabled = false;
        this.fastConnFailover = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PooledConnection getPooledConnection() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.poolLogger.log(Level.FINE, "OracleConnectionPoolDataSource.getPooledConnection()", this);
            OracleLog.recursiveTrace = false;
        }
        String localUser = null;
        String localPassword = null;
        OracleConnectionPoolDataSource oracleConnectionPoolDataSource = this;
        synchronized (oracleConnectionPoolDataSource) {
            localUser = this.user;
            localPassword = this.password;
        }
        return this.getPooledConnection(localUser, localPassword);
    }

    public PooledConnection getPooledConnection(String _user, String _passwd) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.poolLogger.log(Level.FINE, "OracleConnectionPoolDataSource.getPooledConnection(user=" + _user + ", passwd=" + _passwd + ")", this);
            OracleLog.recursiveTrace = false;
        }
        Connection conn = this.getPhysicalConnection(this.url, _user, _passwd);
        OraclePooledConnection opc = new OraclePooledConnection(conn);
        if (_passwd == null) {
            _passwd = this.password;
        }
        opc.setUserName(!_user.startsWith("\"") ? _user.toLowerCase() : _user, _passwd.toUpperCase());
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.poolLogger.log(Level.FINE, "OracleConnectionPoolDataSource.getPooledConnection(user, passwd): returned " + opc, this);
            OracleLog.recursiveTrace = false;
        }
        return opc;
    }

    PooledConnection getPooledConnection(Properties prop) throws SQLException {
        String _passwd;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OracleConnectionPoolDataSource.getPooledConnection(prop=" + prop + ")", this);
            OracleLog.recursiveTrace = false;
        }
        Connection conn = this.getPhysicalConnection(prop);
        OraclePooledConnection opc = new OraclePooledConnection(conn);
        String _user = prop.getProperty("user");
        if (_user == null) {
            _user = ((OracleConnection)conn).getUserName();
        }
        if ((_passwd = prop.getProperty("password")) == null) {
            _passwd = this.password;
        }
        opc.setUserName(!_user.startsWith("\"") ? _user.toLowerCase() : _user, _passwd.toUpperCase());
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OracleConnectionPoolDataSource.getPooledConnection(prop): returned " + opc, this);
            OracleLog.recursiveTrace = false;
        }
        return opc;
    }

    protected Connection getPhysicalConnection() throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.poolLogger.log(Level.FINE, "OracleConnectionPoolDataSource.getPhysicalConnection()", this);
            OracleLog.recursiveTrace = false;
        }
        return super.getConnection(this.user, this.password);
    }

    protected Connection getPhysicalConnection(String _url, String _user, String _passwd) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.poolLogger.log(Level.FINE, "OracleConnectionPoolDataSource.getPhysicalConnection(url=" + _url + ", user=" + _user + "passwd=" + _passwd + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.url = _url;
        return super.getConnection(_user, _passwd);
    }

    protected Connection getPhysicalConnection(String _user, String _passwd) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.poolLogger.log(Level.FINE, "OracleConnectionPoolDataSource.getPhysicalConnection(user=" + _user + ", passwd=" + _passwd + ")", this);
            OracleLog.recursiveTrace = false;
        }
        return super.getConnection(_user, _passwd);
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.pool.OracleConnectionPoolDataSource"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

