/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterRepConstants;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterWalker;

class CharacterSetAL16UTF16LE
extends CharacterSet
implements CharacterRepConstants {
    CharacterSetAL16UTF16LE(int id) {
        super(id);
        this.rep = 5;
    }

    public boolean isLossyFrom(CharacterSet from) {
        return !from.isUnicode();
    }

    public boolean isConvertibleFrom(CharacterSet source) {
        boolean ok = source.rep <= 1024;
        return ok;
    }

    public boolean isUnicode() {
        return true;
    }

    public String toStringWithReplacement(byte[] bytes, int offset, int count) {
        try {
            char[] chars = new char[Math.min(bytes.length - offset >>> 1, count >>> 1)];
            int chars_len = CharacterSet.convertAL16UTF16LEBytesToJavaChars(bytes, offset, chars, 0, count, true);
            return new String(chars, 0, chars_len);
        }
        catch (SQLException e) {
            return "";
        }
    }

    public String toString(byte[] bytes, int offset, int count) throws SQLException {
        try {
            char[] chars = new char[Math.min(bytes.length - offset >>> 1, count >>> 1)];
            int chars_len = CharacterSet.convertAL16UTF16LEBytesToJavaChars(bytes, offset, chars, 0, count, false);
            return new String(chars, 0, chars_len);
        }
        catch (SQLException e) {
            CharacterSetAL16UTF16LE.failUTFConversion();
            return "";
        }
    }

    public byte[] convert(String s) throws SQLException {
        return CharacterSetAL16UTF16LE.stringToAL16UTF16LEBytes(s);
    }

    public byte[] convertWithReplacement(String s) {
        return CharacterSetAL16UTF16LE.stringToAL16UTF16LEBytes(s);
    }

    public byte[] convert(CharacterSet from, byte[] source, int offset, int count) throws SQLException {
        byte[] result;
        if (from.rep == 5) {
            result = CharacterSetAL16UTF16LE.useOrCopy(source, offset, count);
        } else {
            String s = from.toString(source, offset, count);
            result = CharacterSetAL16UTF16LE.stringToAL16UTF16LEBytes(s);
        }
        return result;
    }

    int decode(CharacterWalker walker) throws SQLException {
        byte[] bytes = walker.bytes;
        int bytes_index = walker.next;
        int bytes_end = walker.end;
        if (bytes_index + 2 >= bytes_end) {
            CharacterSetAL16UTF16LE.failUTFConversion();
        }
        byte c1 = bytes[bytes_index++];
        byte c2 = bytes[bytes_index++];
        int result = c1 << 8 & 0xFF00 | c2;
        walker.next = bytes_index;
        return result;
    }

    void encode(CharacterBuffer buffer, int c) throws SQLException {
        if (c > 65535) {
            CharacterSetAL16UTF16LE.failUTFConversion();
        } else {
            CharacterSetAL16UTF16LE.need(buffer, 2);
            buffer.bytes[buffer.next++] = (byte)(c >> 8 & 0xFF);
            buffer.bytes[buffer.next++] = (byte)(c & 0xFF);
        }
    }
}

