/*
 * Decompiled with CFR 0.152.
 */
package com.coreframework.db;

import com.coreframework.db.AbstractSqlParameterSource;
import com.coreframework.db.SqlParameterValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MapSqlParameterSource
extends AbstractSqlParameterSource {
    private final Map values = new HashMap();

    public MapSqlParameterSource() {
    }

    public MapSqlParameterSource(String paramName, Object value) {
        this.addValue(paramName, value);
    }

    public MapSqlParameterSource(Map values) {
        this.addValues(values);
    }

    public MapSqlParameterSource addValue(String paramName, Object value) {
        this.values.put(paramName, value);
        if (value instanceof SqlParameterValue) {
            this.registerSqlType(paramName, ((SqlParameterValue)value).getSqlType());
        }
        return this;
    }

    public MapSqlParameterSource addValue(String paramName, Object value, int sqlType) {
        this.values.put(paramName, value);
        this.registerSqlType(paramName, sqlType);
        return this;
    }

    public MapSqlParameterSource addValue(String paramName, Object value, int sqlType, String typeName) {
        this.values.put(paramName, value);
        this.registerSqlType(paramName, sqlType);
        this.registerTypeName(paramName, typeName);
        return this;
    }

    public MapSqlParameterSource addValues(Map values) {
        if (values != null) {
            for (Map.Entry entry : values.entrySet()) {
                this.values.put((String)entry.getKey(), entry.getValue());
                if (!(entry.getValue() instanceof SqlParameterValue)) continue;
                SqlParameterValue value = (SqlParameterValue)entry.getValue();
                this.registerSqlType((String)entry.getKey(), value.getSqlType());
            }
        }
        return this;
    }

    public Map getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    @Override
    public boolean hasValue(String paramName) {
        return this.values.containsKey(paramName);
    }

    @Override
    public Object getValue(String paramName) {
        if (!this.hasValue(paramName)) {
            throw new IllegalArgumentException("No value registered for key '" + paramName + "'");
        }
        return this.values.get(paramName);
    }
}

