/*
 * Decompiled with CFR 0.152.
 */
package com.yihu.das.dbutils.handlers;

import com.coreframework.db.QueryResult;
import com.yihu.das.dbutils.ResultSetHandler;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractListHandler<T>
implements ResultSetHandler<List<T>> {
    @Override
    public List<T> handle(ResultSet rs) throws SQLException {
        ArrayList<T> rows = new ArrayList<T>();
        while (rs.next()) {
            rows.add(this.handleRow(rs));
        }
        return rows;
    }

    @Override
    public QueryResult<List<T>> handle(ResultSet rs, int start, int pageSize) throws SQLException {
        ArrayList<T> rows = new ArrayList<T>();
        QueryResult<List<ArrayList<T>>> qr = new QueryResult<List<ArrayList<T>>>();
        qr.setStart(start);
        qr.setPageSize(pageSize);
        int c = 0;
        if (pageSize > 1000) {
            pageSize = 1000;
        }
        if (!rs.last()) {
            qr.setResult(rows);
            return qr;
        }
        int rowCount = rs.getRow();
        if (pageSize > rowCount) {
            pageSize = rowCount;
        }
        int pageCount = (rowCount + pageSize) / pageSize;
        qr.setPageCount(pageCount);
        qr.setRowCount(rowCount);
        if (pageCount <= 0) {
            qr.setResult(rows);
            return qr;
        }
        int current = start;
        if (!rs.absolute(start == 0 ? 1 : current + 1)) {
            qr.setResult(rows);
            return qr;
        }
        do {
            rows.add(this.handleRow(rs));
        } while (++c < pageSize && rs.next());
        qr.setResult(rows);
        return qr;
    }

    protected abstract T handleRow(ResultSet var1) throws SQLException;
}

