/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbcx;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import net.sourceforge.jtds.jdbc.DefaultProperties;
import net.sourceforge.jtds.jdbc.Driver;
import net.sourceforge.jtds.jdbc.Messages;
import net.sourceforge.jtds.jdbc.Support;
import net.sourceforge.jtds.jdbcx.JtdsObjectFactory;
import net.sourceforge.jtds.jdbcx.JtdsXAConnection;
import net.sourceforge.jtds.jdbcx.PooledConnection;
import net.sourceforge.jtds.util.Logger;

public class JtdsDataSource
implements DataSource,
ConnectionPoolDataSource,
XADataSource,
Referenceable,
Serializable {
    static final long serialVersionUID = 266240L;
    protected String serverName;
    protected String serverType;
    protected String portNumber;
    protected String databaseName;
    protected String tdsVersion;
    protected String charset;
    protected String language;
    protected String domain;
    protected String useNTLMV2;
    protected String instance;
    protected String lastUpdateCount;
    protected String sendStringParametersAsUnicode;
    protected String namedPipe;
    protected String macAddress;
    protected String prepareSql;
    protected String packetSize;
    protected String tcpNoDelay;
    protected String user;
    protected String password;
    protected String loginTimeout;
    protected String lobBuffer;
    protected String maxStatements;
    protected String appName;
    protected String progName;
    protected String wsid;
    protected String xaEmulation;
    protected String logFile;
    protected String socketTimeout;
    protected String socketKeepAlive;
    protected String processId;
    protected String ssl;
    protected String batchSize;
    protected String bufferDir;
    protected String bufferMaxMemory;
    protected String bufferMinPackets;
    protected String cacheMetaData;
    protected String useCursors;
    protected String useLOBs;
    protected String bindAddress;
    protected String useJCIFS;
    protected String description;
    private static final Driver driver = new Driver();

    @Override
    public XAConnection getXAConnection() throws SQLException {
        return new JtdsXAConnection(this, this.getConnection(this.user, this.password));
    }

    @Override
    public XAConnection getXAConnection(String user, String password) throws SQLException {
        return new JtdsXAConnection(this, this.getConnection(user, password));
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.password);
    }

    @Override
    public Connection getConnection(String user, String password) throws SQLException {
        String url;
        if (this.serverName == null) {
            throw new SQLException(Messages.get("error.connection.nohost"), "08001");
        }
        if (this.getLogWriter() == null && this.logFile != null && this.logFile.length() > 0) {
            try {
                this.setLogWriter(new PrintWriter(new FileOutputStream(this.logFile), true));
            }
            catch (IOException e) {
                System.err.println("jTDS: Failed to set log file " + e);
            }
        }
        Properties props = new Properties();
        this.addNonNullProperties(props, user, password);
        try {
            int serverTypeDef = this.serverType == null ? 0 : Integer.parseInt(this.serverType);
            url = "jdbc:jtds:" + DefaultProperties.getServerTypeWithDefault(serverTypeDef) + ':';
        }
        catch (RuntimeException ex) {
            SQLException sqlException = new SQLException(Messages.get("error.connection.servertype", ex.toString()), "08001");
            Support.linkException(sqlException, (Throwable)ex);
            throw sqlException;
        }
        return driver.connect(url, props);
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference ref = new Reference(this.getClass().getName(), JtdsObjectFactory.class.getName(), null);
        ref.add(new StringRefAddr(Messages.get("prop.servername"), this.serverName));
        ref.add(new StringRefAddr(Messages.get("prop.servertype"), this.serverType));
        ref.add(new StringRefAddr(Messages.get("prop.portnumber"), this.portNumber));
        ref.add(new StringRefAddr(Messages.get("prop.databasename"), this.databaseName));
        ref.add(new StringRefAddr(Messages.get("prop.tds"), this.tdsVersion));
        ref.add(new StringRefAddr(Messages.get("prop.charset"), this.charset));
        ref.add(new StringRefAddr(Messages.get("prop.language"), this.language));
        ref.add(new StringRefAddr(Messages.get("prop.domain"), this.domain));
        ref.add(new StringRefAddr(Messages.get("prop.usentlmv2"), this.useNTLMV2));
        ref.add(new StringRefAddr(Messages.get("prop.instance"), this.instance));
        ref.add(new StringRefAddr(Messages.get("prop.lastupdatecount"), this.lastUpdateCount));
        ref.add(new StringRefAddr(Messages.get("prop.useunicode"), this.sendStringParametersAsUnicode));
        ref.add(new StringRefAddr(Messages.get("prop.namedpipe"), this.namedPipe));
        ref.add(new StringRefAddr(Messages.get("prop.macaddress"), this.macAddress));
        ref.add(new StringRefAddr(Messages.get("prop.preparesql"), this.prepareSql));
        ref.add(new StringRefAddr(Messages.get("prop.packetsize"), this.packetSize));
        ref.add(new StringRefAddr(Messages.get("prop.tcpnodelay"), this.tcpNoDelay));
        ref.add(new StringRefAddr(Messages.get("prop.xaemulation"), this.xaEmulation));
        ref.add(new StringRefAddr(Messages.get("prop.user"), this.user));
        ref.add(new StringRefAddr(Messages.get("prop.password"), this.password));
        ref.add(new StringRefAddr(Messages.get("prop.logintimeout"), this.loginTimeout));
        ref.add(new StringRefAddr(Messages.get("prop.sotimeout"), this.socketTimeout));
        ref.add(new StringRefAddr(Messages.get("prop.sokeepalive"), this.socketKeepAlive));
        ref.add(new StringRefAddr(Messages.get("prop.processid"), this.processId));
        ref.add(new StringRefAddr(Messages.get("prop.lobbuffer"), this.lobBuffer));
        ref.add(new StringRefAddr(Messages.get("prop.maxstatements"), this.maxStatements));
        ref.add(new StringRefAddr(Messages.get("prop.appname"), this.appName));
        ref.add(new StringRefAddr(Messages.get("prop.progname"), this.progName));
        ref.add(new StringRefAddr(Messages.get("prop.wsid"), this.wsid));
        ref.add(new StringRefAddr(Messages.get("prop.logfile"), this.logFile));
        ref.add(new StringRefAddr(Messages.get("prop.ssl"), this.ssl));
        ref.add(new StringRefAddr(Messages.get("prop.batchsize"), this.batchSize));
        ref.add(new StringRefAddr(Messages.get("prop.bufferdir"), this.bufferDir));
        ref.add(new StringRefAddr(Messages.get("prop.buffermaxmemory"), this.bufferMaxMemory));
        ref.add(new StringRefAddr(Messages.get("prop.bufferminpackets"), this.bufferMinPackets));
        ref.add(new StringRefAddr(Messages.get("prop.cachemetadata"), this.cacheMetaData));
        ref.add(new StringRefAddr(Messages.get("prop.usecursors"), this.useCursors));
        ref.add(new StringRefAddr(Messages.get("prop.uselobs"), this.useLOBs));
        ref.add(new StringRefAddr(Messages.get("prop.bindaddress"), this.bindAddress));
        ref.add(new StringRefAddr(Messages.get("prop.usejcifs"), this.useJCIFS));
        ref.add(new StringRefAddr("description", this.description));
        return ref;
    }

    @Override
    public javax.sql.PooledConnection getPooledConnection() throws SQLException {
        return this.getPooledConnection(this.user, this.password);
    }

    @Override
    public synchronized javax.sql.PooledConnection getPooledConnection(String user, String password) throws SQLException {
        return new PooledConnection(this.getConnection(user, password));
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return Logger.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        Logger.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int loginTimeout) throws SQLException {
        this.loginTimeout = String.valueOf(loginTimeout);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        if (this.loginTimeout == null) {
            return 0;
        }
        return Integer.parseInt(this.loginTimeout);
    }

    public void setSocketTimeout(int socketTimeout) throws SQLException {
        this.socketTimeout = String.valueOf(socketTimeout);
    }

    public void setSocketKeepAlive(boolean socketKeepAlive) throws SQLException {
        this.socketKeepAlive = String.valueOf(socketKeepAlive);
    }

    public void setProcessId(String processId) throws SQLException {
        this.processId = String.valueOf(processId);
    }

    public int getSocketTimeout() throws SQLException {
        if (this.socketTimeout == null) {
            return 0;
        }
        return Integer.parseInt(this.socketTimeout);
    }

    public boolean getSocketKeepAlive() throws SQLException {
        return Boolean.valueOf(this.socketKeepAlive);
    }

    public String getProcessId() throws SQLException {
        return this.processId;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = String.valueOf(portNumber);
    }

    public int getPortNumber() {
        if (this.portNumber == null) {
            return 0;
        }
        return Integer.parseInt(this.portNumber);
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    public void setTds(String tds) {
        this.tdsVersion = tds;
    }

    public String getTds() {
        return this.tdsVersion;
    }

    public void setServerType(int serverType) {
        this.serverType = String.valueOf(serverType);
    }

    public int getServerType() {
        if (this.serverType == null) {
            return 0;
        }
        return Integer.parseInt(this.serverType);
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getUseNTLMV2() {
        return this.useNTLMV2;
    }

    public void setUseNTLMV2(String usentlmv2) {
        this.useNTLMV2 = usentlmv2;
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public boolean getSendStringParametersAsUnicode() {
        return Boolean.valueOf(this.sendStringParametersAsUnicode);
    }

    public void setSendStringParametersAsUnicode(boolean sendStringParametersAsUnicode) {
        this.sendStringParametersAsUnicode = String.valueOf(sendStringParametersAsUnicode);
    }

    public boolean getNamedPipe() {
        return Boolean.valueOf(this.namedPipe);
    }

    public void setNamedPipe(boolean namedPipe) {
        this.namedPipe = String.valueOf(namedPipe);
    }

    public boolean getLastUpdateCount() {
        return Boolean.valueOf(this.lastUpdateCount);
    }

    public void setLastUpdateCount(boolean lastUpdateCount) {
        this.lastUpdateCount = String.valueOf(lastUpdateCount);
    }

    public boolean getXaEmulation() {
        return Boolean.valueOf(this.xaEmulation);
    }

    public void setXaEmulation(boolean xaEmulation) {
        this.xaEmulation = String.valueOf(xaEmulation);
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public void setPacketSize(int packetSize) {
        this.packetSize = String.valueOf(packetSize);
    }

    public int getPacketSize() {
        if (this.packetSize == null) {
            return 0;
        }
        return Integer.parseInt(this.packetSize);
    }

    public boolean getTcpNoDelay() {
        return Boolean.valueOf(this.tcpNoDelay);
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = String.valueOf(tcpNoDelay);
    }

    public void setPrepareSql(int prepareSql) {
        this.prepareSql = String.valueOf(prepareSql);
    }

    public int getPrepareSql() {
        if (this.prepareSql == null) {
            return 0;
        }
        return Integer.parseInt(this.prepareSql);
    }

    public void setLobBuffer(long lobBuffer) {
        this.lobBuffer = String.valueOf(lobBuffer);
    }

    public long getLobBuffer() {
        if (this.lobBuffer == null) {
            return 0L;
        }
        return Long.parseLong(this.lobBuffer);
    }

    public void setMaxStatements(int maxStatements) {
        this.maxStatements = String.valueOf(maxStatements);
    }

    public int getMaxStatements() {
        if (this.maxStatements == null) {
            return 0;
        }
        return Integer.parseInt(this.maxStatements);
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setProgName(String progName) {
        this.progName = progName;
    }

    public String getProgName() {
        return this.progName;
    }

    public void setWsid(String wsid) {
        this.wsid = wsid;
    }

    public String getWsid() {
        return this.wsid;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setSsl(String ssl) {
        this.ssl = ssl;
    }

    public String getSsl() {
        return this.ssl;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = String.valueOf(batchSize);
    }

    public int getBatchSize() {
        if (this.batchSize == null) {
            return 0;
        }
        return Integer.parseInt(this.batchSize);
    }

    public String getBufferDir() {
        if (this.bufferDir == null) {
            return System.getProperty("java.io.tmpdir");
        }
        return this.bufferDir;
    }

    public void setBufferDir(String bufferDir) {
        this.bufferDir = bufferDir;
    }

    public int getBufferMaxMemory() {
        if (this.bufferMaxMemory == null) {
            return 0;
        }
        return Integer.parseInt(this.bufferMaxMemory);
    }

    public void setBufferMaxMemory(int bufferMaxMemory) {
        this.bufferMaxMemory = String.valueOf(bufferMaxMemory);
    }

    public int getBufferMinPackets() {
        if (this.bufferMinPackets == null) {
            return 0;
        }
        return Integer.parseInt(this.bufferMinPackets);
    }

    public void setBufferMinPackets(int bufferMinPackets) {
        this.bufferMinPackets = String.valueOf(bufferMinPackets);
    }

    public boolean getCacheMetaData() {
        return Boolean.valueOf(this.cacheMetaData);
    }

    public void setCacheMetaData(boolean cacheMetaData) {
        this.cacheMetaData = String.valueOf(cacheMetaData);
    }

    public boolean getUseCursors() {
        return Boolean.valueOf(this.useCursors);
    }

    public void setUseCursors(boolean useCursors) {
        this.useCursors = String.valueOf(useCursors);
    }

    public boolean getUseLOBs() {
        return Boolean.valueOf(this.useLOBs);
    }

    public void setUseLOBs(boolean useLOBs) {
        this.useLOBs = String.valueOf(useLOBs);
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    public boolean getUseJCIFS() {
        return Boolean.valueOf(this.useJCIFS);
    }

    public void setUseJCIFS(boolean useJCIFS) {
        this.useJCIFS = String.valueOf(useJCIFS);
    }

    private void addNonNullProperties(Properties props, String user, String password) {
        props.setProperty(Messages.get("prop.servername"), this.serverName);
        if (this.serverType != null) {
            props.setProperty(Messages.get("prop.servertype"), this.serverType);
        }
        if (this.portNumber != null) {
            props.setProperty(Messages.get("prop.portnumber"), this.portNumber);
        }
        if (this.databaseName != null) {
            props.setProperty(Messages.get("prop.databasename"), this.databaseName);
        }
        if (this.tdsVersion != null) {
            props.setProperty(Messages.get("prop.tds"), this.tdsVersion);
        }
        if (this.charset != null) {
            props.setProperty(Messages.get("prop.charset"), this.charset);
        }
        if (this.language != null) {
            props.setProperty(Messages.get("prop.language"), this.language);
        }
        if (this.domain != null) {
            props.setProperty(Messages.get("prop.domain"), this.domain);
        }
        if (this.useNTLMV2 != null) {
            props.setProperty(Messages.get("prop.usentlmv2"), this.useNTLMV2);
        }
        if (this.instance != null) {
            props.setProperty(Messages.get("prop.instance"), this.instance);
        }
        if (this.lastUpdateCount != null) {
            props.setProperty(Messages.get("prop.lastupdatecount"), this.lastUpdateCount);
        }
        if (this.sendStringParametersAsUnicode != null) {
            props.setProperty(Messages.get("prop.useunicode"), this.sendStringParametersAsUnicode);
        }
        if (this.namedPipe != null) {
            props.setProperty(Messages.get("prop.namedpipe"), this.namedPipe);
        }
        if (this.macAddress != null) {
            props.setProperty(Messages.get("prop.macaddress"), this.macAddress);
        }
        if (this.prepareSql != null) {
            props.setProperty(Messages.get("prop.preparesql"), this.prepareSql);
        }
        if (this.packetSize != null) {
            props.setProperty(Messages.get("prop.packetsize"), this.packetSize);
        }
        if (this.tcpNoDelay != null) {
            props.setProperty(Messages.get("prop.tcpnodelay"), this.tcpNoDelay);
        }
        if (this.xaEmulation != null) {
            props.setProperty(Messages.get("prop.xaemulation"), this.xaEmulation);
        }
        if (user != null) {
            props.setProperty(Messages.get("prop.user"), user);
        }
        if (password != null) {
            props.setProperty(Messages.get("prop.password"), password);
        }
        if (this.loginTimeout != null) {
            props.setProperty(Messages.get("prop.logintimeout"), this.loginTimeout);
        }
        if (this.socketTimeout != null) {
            props.setProperty(Messages.get("prop.sotimeout"), this.socketTimeout);
        }
        if (this.socketKeepAlive != null) {
            props.setProperty(Messages.get("prop.sokeepalive"), this.socketKeepAlive);
        }
        if (this.processId != null) {
            props.setProperty(Messages.get("prop.processid"), this.processId);
        }
        if (this.lobBuffer != null) {
            props.setProperty(Messages.get("prop.lobbuffer"), this.lobBuffer);
        }
        if (this.maxStatements != null) {
            props.setProperty(Messages.get("prop.maxstatements"), this.maxStatements);
        }
        if (this.appName != null) {
            props.setProperty(Messages.get("prop.appname"), this.appName);
        }
        if (this.progName != null) {
            props.setProperty(Messages.get("prop.progname"), this.progName);
        }
        if (this.wsid != null) {
            props.setProperty(Messages.get("prop.wsid"), this.wsid);
        }
        if (this.ssl != null) {
            props.setProperty(Messages.get("prop.ssl"), this.ssl);
        }
        if (this.batchSize != null) {
            props.setProperty(Messages.get("prop.batchsize"), this.batchSize);
        }
        if (this.bufferDir != null) {
            props.setProperty(Messages.get("prop.bufferdir"), this.bufferDir);
        }
        if (this.bufferMaxMemory != null) {
            props.setProperty(Messages.get("prop.buffermaxmemory"), this.bufferMaxMemory);
        }
        if (this.bufferMinPackets != null) {
            props.setProperty(Messages.get("prop.bufferminpackets"), this.bufferMinPackets);
        }
        if (this.cacheMetaData != null) {
            props.setProperty(Messages.get("prop.cachemetadata"), this.cacheMetaData);
        }
        if (this.useCursors != null) {
            props.setProperty(Messages.get("prop.usecursors"), this.useCursors);
        }
        if (this.useLOBs != null) {
            props.setProperty(Messages.get("prop.uselobs"), this.useLOBs);
        }
        if (this.bindAddress != null) {
            props.setProperty(Messages.get("prop.bindaddress"), this.bindAddress);
        }
        if (this.useJCIFS != null) {
            props.setProperty(Messages.get("prop.usejcifs"), this.useJCIFS);
        }
    }

    public boolean isWrapperFor(Class arg0) throws SQLException {
        throw new AbstractMethodError();
    }

    public Object unwrap(Class arg0) throws SQLException {
        throw new AbstractMethodError();
    }
}

