/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.BitSetProducer;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.aliases.IndexAliasesService;
import org.elasticsearch.index.cache.IndexCache;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.IgnoreOnRecoveryEngineException;
import org.elasticsearch.index.mapper.DocumentMapperForType;
import org.elasticsearch.index.mapper.MapperException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.query.IndexQueryParserService;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;

public class TranslogRecoveryPerformer {
    private final MapperService mapperService;
    private final IndexQueryParserService queryParserService;
    private final IndexAliasesService indexAliasesService;
    private final IndexCache indexCache;
    private final ESLogger logger;
    private final Map<String, Mapping> recoveredTypes = new HashMap<String, Mapping>();
    private final ShardId shardId;

    protected TranslogRecoveryPerformer(ShardId shardId, MapperService mapperService, IndexQueryParserService queryParserService, IndexAliasesService indexAliasesService, IndexCache indexCache, ESLogger logger) {
        this.shardId = shardId;
        this.mapperService = mapperService;
        this.queryParserService = queryParserService;
        this.indexAliasesService = indexAliasesService;
        this.indexCache = indexCache;
        this.logger = logger;
    }

    protected DocumentMapperForType docMapper(String type) {
        return this.mapperService.documentMapperWithAutoCreate(type);
    }

    int performBatchRecovery(Engine engine, Iterable<Translog.Operation> operations) {
        int numOps = 0;
        try {
            for (Translog.Operation operation : operations) {
                this.performRecoveryOperation(engine, operation, false);
                ++numOps;
            }
            engine.getTranslog().sync();
        }
        catch (Throwable t) {
            throw new BatchOperationException(this.shardId, "failed to apply batch translog operation [" + t.getMessage() + "]", numOps, t);
        }
        return numOps;
    }

    private void maybeAddMappingUpdate(String type, Mapping update, String docId, boolean allowMappingUpdates) {
        if (update == null) {
            return;
        }
        if (!allowMappingUpdates) {
            throw new MapperException("mapping updates are not allowed (type: [" + type + "], id: [" + docId + "])");
        }
        Mapping currentUpdate = this.recoveredTypes.get(type);
        if (currentUpdate == null) {
            this.recoveredTypes.put(type, update);
        } else {
            currentUpdate = currentUpdate.merge(update, false);
        }
    }

    public void performRecoveryOperation(Engine engine, Translog.Operation operation, boolean allowMappingUpdates) {
        block13: {
            try {
                switch (operation.opType()) {
                    case CREATE: {
                        Translog.Create create = (Translog.Create)operation;
                        Engine.Create engineCreate = IndexShard.prepareCreate(this.docMapper(create.type()), SourceToParse.source(create.source()).index(this.shardId.getIndex()).type(create.type()).id(create.id()).routing(create.routing()).parent(create.parent()).timestamp(create.timestamp()).ttl(create.ttl()), create.version(), create.versionType().versionTypeForReplicationAndRecovery(), Engine.Operation.Origin.RECOVERY, true, false);
                        this.maybeAddMappingUpdate(engineCreate.type(), engineCreate.parsedDoc().dynamicMappingsUpdate(), engineCreate.id(), allowMappingUpdates);
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace("[translog] recover [create] op of [{}][{}]", create.type(), create.id());
                        }
                        engine.create(engineCreate);
                        break;
                    }
                    case SAVE: {
                        Translog.Index index = (Translog.Index)operation;
                        Engine.Index engineIndex = IndexShard.prepareIndex(this.docMapper(index.type()), SourceToParse.source(index.source()).type(index.type()).id(index.id()).routing(index.routing()).parent(index.parent()).timestamp(index.timestamp()).ttl(index.ttl()), index.version(), index.versionType().versionTypeForReplicationAndRecovery(), Engine.Operation.Origin.RECOVERY, true);
                        this.maybeAddMappingUpdate(engineIndex.type(), engineIndex.parsedDoc().dynamicMappingsUpdate(), engineIndex.id(), allowMappingUpdates);
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace("[translog] recover [index] op of [{}][{}]", index.type(), index.id());
                        }
                        engine.index(engineIndex);
                        break;
                    }
                    case DELETE: {
                        Translog.Delete delete = (Translog.Delete)operation;
                        Uid uid = Uid.createUid(delete.uid().text());
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace("[translog] recover [delete] op of [{}][{}]", uid.type(), uid.id());
                        }
                        engine.delete(new Engine.Delete(uid.type(), uid.id(), delete.uid(), delete.version(), delete.versionType().versionTypeForReplicationAndRecovery(), Engine.Operation.Origin.RECOVERY, System.nanoTime(), false));
                        break;
                    }
                    case DELETE_BY_QUERY: {
                        Translog.DeleteByQuery deleteByQuery = (Translog.DeleteByQuery)operation;
                        engine.delete(TranslogRecoveryPerformer.prepareDeleteByQuery(this.queryParserService, this.mapperService, this.indexAliasesService, this.indexCache, deleteByQuery.source(), deleteByQuery.filteringAliases(), Engine.Operation.Origin.RECOVERY, deleteByQuery.types()));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("No operation defined for [" + operation + "]");
                    }
                }
            }
            catch (ElasticsearchException e) {
                boolean hasIgnoreOnRecoveryException = false;
                ElasticsearchException current = e;
                while (true) {
                    if (current instanceof IgnoreOnRecoveryEngineException) {
                        hasIgnoreOnRecoveryException = true;
                        break;
                    }
                    if (!(current.getCause() instanceof ElasticsearchException)) break;
                    current = (ElasticsearchException)current.getCause();
                }
                if (hasIgnoreOnRecoveryException) break block13;
                throw e;
            }
        }
        this.operationProcessed();
    }

    private static Engine.DeleteByQuery prepareDeleteByQuery(IndexQueryParserService queryParserService, MapperService mapperService, IndexAliasesService indexAliasesService, IndexCache indexCache, BytesReference source, @Nullable String[] filteringAliases, Engine.Operation.Origin origin, String ... types) {
        Query query;
        long startTime = System.nanoTime();
        if (types == null) {
            types = Strings.EMPTY_ARRAY;
        }
        try {
            query = queryParserService.parseQuery(source).query();
        }
        catch (QueryParsingException ex) {
            if (queryParserService.getIndexCreatedVersion().onOrBefore(Version.V_1_0_0_Beta2)) {
                try {
                    XContentParser parser = XContentHelper.createParser(source);
                    ParsedQuery parse = queryParserService.parse(parser);
                    query = parse.query();
                }
                catch (Throwable t) {
                    ex.addSuppressed(t);
                    throw ex;
                }
            }
            throw ex;
        }
        Query searchFilter = mapperService.searchFilter(types);
        if (searchFilter != null) {
            query = Queries.filtered(query, searchFilter);
        }
        Query aliasFilter = indexAliasesService.aliasFilter(filteringAliases);
        BitSetProducer parentFilter = mapperService.hasNested() ? indexCache.bitsetFilterCache().getBitSetProducer(Queries.newNonNestedFilter()) : null;
        return new Engine.DeleteByQuery(query, source, filteringAliases, aliasFilter, parentFilter, origin, startTime, types);
    }

    protected void operationProcessed() {
    }

    public Map<String, Mapping> getRecoveredTypes() {
        return this.recoveredTypes;
    }

    public static class BatchOperationException
    extends ElasticsearchException {
        private final int completedOperations;

        public BatchOperationException(ShardId shardId, String msg, int completedOperations, Throwable cause) {
            super(msg, cause, new Object[0]);
            this.setShard(shardId);
            this.completedOperations = completedOperations;
        }

        public BatchOperationException(StreamInput in) throws IOException {
            super(in);
            this.completedOperations = in.readInt();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeInt(this.completedOperations);
        }

        public int completedOperations() {
            return this.completedOperations;
        }
    }
}

