/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import jxl.CellType;
import jxl.DateCell;
import jxl.NumberFormulaCell;
import jxl.biff.FormattingRecords;
import jxl.biff.FormulaData;
import jxl.biff.formula.ExternalSheet;
import jxl.biff.formula.FormulaException;
import jxl.biff.formula.FormulaParser;
import jxl.read.biff.DateRecord;
import jxl.read.biff.NumberFormulaRecord;
import jxl.read.biff.SheetImpl;

class DateFormulaRecord
extends DateRecord
implements DateCell,
FormulaData,
NumberFormulaCell {
    private double value;
    private String formulaString;
    private ExternalSheet externalSheet;
    private byte[] data;

    public DateFormulaRecord(NumberFormulaRecord t, FormattingRecords fr, ExternalSheet es, boolean nf, SheetImpl si) {
        super(t, t.getXFIndex(), fr, nf, si);
        this.externalSheet = es;
        this.data = t.getFormulaData();
    }

    public CellType getType() {
        return CellType.NUMBER_FORMULA;
    }

    public byte[] getFormulaData() {
        return this.data;
    }

    public String getFormula() throws FormulaException {
        if (this.formulaString == null) {
            byte[] tokens = new byte[this.data.length - 22];
            System.arraycopy(this.data, 22, tokens, 0, tokens.length);
            FormulaParser fp = new FormulaParser(tokens, this, this.externalSheet);
            fp.parse();
            this.formulaString = fp.getFormula();
        }
        return this.formulaString;
    }

    public double getValue() {
        return this.value;
    }
}

