/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.ServerAddress;
import com.mongodb.TagSet;
import com.mongodb.annotations.Immutable;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ClusterType;
import com.mongodb.connection.ServerDescription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

@Immutable
public class ClusterDescription {
    private final ClusterConnectionMode connectionMode;
    private final ClusterType type;
    private final Set<ServerDescription> all;

    public ClusterDescription(ClusterConnectionMode connectionMode, ClusterType type, List<ServerDescription> serverDescriptions) {
        Assertions.notNull("all", serverDescriptions);
        this.connectionMode = Assertions.notNull("connectionMode", connectionMode);
        this.type = Assertions.notNull("type", type);
        TreeSet<ServerDescription> serverDescriptionSet = new TreeSet<ServerDescription>(new Comparator<ServerDescription>(){

            @Override
            public int compare(ServerDescription o1, ServerDescription o2) {
                return o1.getAddress().toString().compareTo(o2.getAddress().toString());
            }
        });
        serverDescriptionSet.addAll(serverDescriptions);
        this.all = Collections.unmodifiableSet(serverDescriptionSet);
    }

    public boolean isCompatibleWithDriver() {
        for (ServerDescription cur : this.all) {
            if (cur.isCompatibleWithDriver()) continue;
            return false;
        }
        return true;
    }

    public ClusterConnectionMode getConnectionMode() {
        return this.connectionMode;
    }

    public ClusterType getType() {
        return this.type;
    }

    public Set<ServerDescription> getAll() {
        return this.all;
    }

    public ServerDescription getByServerAddress(ServerAddress serverAddress) {
        for (ServerDescription cur : this.getAll()) {
            if (!cur.isOk() || !cur.getAddress().equals(serverAddress)) continue;
            return cur;
        }
        return null;
    }

    public List<ServerDescription> getPrimaries() {
        return this.getServersByPredicate(new Predicate(){

            @Override
            public boolean apply(ServerDescription serverDescription) {
                return serverDescription.isPrimary();
            }
        });
    }

    public List<ServerDescription> getSecondaries() {
        return this.getServersByPredicate(new Predicate(){

            @Override
            public boolean apply(ServerDescription serverDescription) {
                return serverDescription.isSecondary();
            }
        });
    }

    public List<ServerDescription> getSecondaries(final TagSet tagSet) {
        return this.getServersByPredicate(new Predicate(){

            @Override
            public boolean apply(ServerDescription serverDescription) {
                return serverDescription.isSecondary() && serverDescription.hasTags(tagSet);
            }
        });
    }

    public List<ServerDescription> getAny() {
        return this.getServersByPredicate(new Predicate(){

            @Override
            public boolean apply(ServerDescription serverDescription) {
                return serverDescription.isOk();
            }
        });
    }

    public List<ServerDescription> getAnyPrimaryOrSecondary() {
        return this.getServersByPredicate(new Predicate(){

            @Override
            public boolean apply(ServerDescription serverDescription) {
                return serverDescription.isPrimary() || serverDescription.isSecondary();
            }
        });
    }

    public List<ServerDescription> getAnyPrimaryOrSecondary(final TagSet tagSet) {
        return this.getServersByPredicate(new Predicate(){

            @Override
            public boolean apply(ServerDescription serverDescription) {
                return (serverDescription.isPrimary() || serverDescription.isSecondary()) && serverDescription.hasTags(tagSet);
            }
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterDescription that = (ClusterDescription)o;
        if (!this.all.equals(that.all)) {
            return false;
        }
        return this.connectionMode == that.connectionMode;
    }

    public int hashCode() {
        int result = this.all.hashCode();
        result = 31 * result + this.connectionMode.hashCode();
        return result;
    }

    public String toString() {
        return "ClusterDescription{type=" + (Object)((Object)this.getType()) + ", connectionMode=" + (Object)((Object)this.connectionMode) + ", all=" + this.all + '}';
    }

    public String getShortDescription() {
        StringBuilder serverDescriptions = new StringBuilder();
        String delimiter = "";
        for (ServerDescription cur : this.all) {
            serverDescriptions.append(delimiter).append(cur.getShortDescription());
            delimiter = ", ";
        }
        return String.format("{type=%s, servers=[%s]", new Object[]{this.type, serverDescriptions});
    }

    private List<ServerDescription> getServersByPredicate(Predicate predicate) {
        ArrayList<ServerDescription> membersByTag = new ArrayList<ServerDescription>();
        for (ServerDescription cur : this.all) {
            if (!predicate.apply(cur)) continue;
            membersByTag.add(cur);
        }
        return membersByTag;
    }

    private static interface Predicate {
        public boolean apply(ServerDescription var1);
    }
}

