/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Time;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.DateCommonBinder;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OraclePreparedStatementReadOnly;

class TimeBinder
extends DateCommonBinder {
    Binder theTimeCopyingBinder = OraclePreparedStatementReadOnly.theStaticTimeCopyingBinder;

    static void init(Binder x) {
        x.type = (short)12;
        x.bytelen = 7;
    }

    TimeBinder() {
        TimeBinder.init(this);
    }

    Binder copyingBinder() {
        return this.theTimeCopyingBinder;
    }

    void bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues) {
        Time[] times = stmt.parameterTime[rank];
        Time value = times[bindPosition];
        if (clearPriorBindValues) {
            times[bindPosition] = null;
        }
        if (value == null) {
            bindIndicators[indoffset] = -1;
        } else {
            bindIndicators[indoffset] = 0;
            TimeBinder.setOracleHMS(TimeBinder.setOracleCYMD(value.getTime(), bindBytes, byteoffset, stmt), bindBytes, byteoffset);
            bindIndicators[lenoffset] = (short)bytePitch;
        }
    }
}

