/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.config.annotation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.web.socket.handler.WebSocketHandlerDecoratorFactory;

public class WebSocketTransportRegistration {
    private Integer messageSizeLimit;
    private Integer sendTimeLimit;
    private Integer sendBufferSizeLimit;
    private final List<WebSocketHandlerDecoratorFactory> decoratorFactories = new ArrayList<WebSocketHandlerDecoratorFactory>(2);

    public WebSocketTransportRegistration setMessageSizeLimit(int messageSizeLimit) {
        this.messageSizeLimit = messageSizeLimit;
        return this;
    }

    protected Integer getMessageSizeLimit() {
        return this.messageSizeLimit;
    }

    public WebSocketTransportRegistration setSendTimeLimit(int timeLimit) {
        this.sendTimeLimit = timeLimit;
        return this;
    }

    protected Integer getSendTimeLimit() {
        return this.sendTimeLimit;
    }

    public WebSocketTransportRegistration setSendBufferSizeLimit(int sendBufferSizeLimit) {
        this.sendBufferSizeLimit = sendBufferSizeLimit;
        return this;
    }

    protected Integer getSendBufferSizeLimit() {
        return this.sendBufferSizeLimit;
    }

    public WebSocketTransportRegistration setDecoratorFactories(WebSocketHandlerDecoratorFactory ... factories) {
        if (factories != null) {
            this.decoratorFactories.addAll(Arrays.asList(factories));
        }
        return this;
    }

    public WebSocketTransportRegistration addDecoratorFactory(WebSocketHandlerDecoratorFactory factory) {
        this.decoratorFactories.add(factory);
        return this;
    }

    protected List<WebSocketHandlerDecoratorFactory> getDecoratorFactories() {
        return this.decoratorFactories;
    }
}

