/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.formula;

import java.util.Stack;
import jxl.biff.IntegerHelper;
import jxl.biff.formula.FormulaException;
import jxl.biff.formula.Function;
import jxl.biff.formula.Operator;
import jxl.biff.formula.ParseItem;
import jxl.biff.formula.ParsedThing;
import jxl.biff.formula.Token;

class VariableArgFunction
extends Operator
implements ParsedThing {
    private Function function;
    private int arguments;
    private boolean readFromSheet;

    public VariableArgFunction() {
        this.readFromSheet = true;
    }

    public VariableArgFunction(Function f, int a) {
        this.function = f;
        this.arguments = a;
        this.readFromSheet = false;
    }

    public int read(byte[] data, int pos) throws FormulaException {
        this.arguments = data[pos];
        int index = IntegerHelper.getInt(data[pos + 1], data[pos + 2]);
        this.function = Function.getFunction(index);
        if (this.function == Function.UNKNOWN) {
            throw new FormulaException(FormulaException.unrecognizedFunction, index);
        }
        return 3;
    }

    public void getOperands(Stack s) {
        ParseItem[] items = new ParseItem[this.arguments];
        int i = this.arguments - 1;
        while (i >= 0) {
            ParseItem pi;
            items[i] = pi = (ParseItem)s.pop();
            --i;
        }
        int i2 = 0;
        while (i2 < this.arguments) {
            this.add(items[i2]);
            ++i2;
        }
    }

    public void getString(StringBuffer buf) {
        buf.append(this.function.string);
        buf.append('(');
        if (this.arguments > 0) {
            ParseItem[] operands = this.getOperands();
            if (this.readFromSheet) {
                operands[0].getString(buf);
                int i = 1;
                while (i < this.arguments) {
                    buf.append(',');
                    operands[i].getString(buf);
                    ++i;
                }
            } else {
                operands[this.arguments - 1].getString(buf);
                int i = this.arguments - 2;
                while (i >= 0) {
                    buf.append(',');
                    operands[i].getString(buf);
                    --i;
                }
            }
        }
        buf.append(')');
    }

    Function getFunction() {
        return this.function;
    }

    byte[] getBytes() {
        ParseItem[] operands = this.getOperands();
        byte[] data = new byte[]{};
        int i = operands.length - 1;
        while (i >= 0) {
            byte[] opdata = operands[i].getBytes();
            byte[] newdata = new byte[data.length + opdata.length];
            System.arraycopy(data, 0, newdata, 0, data.length);
            System.arraycopy(opdata, 0, newdata, data.length, opdata.length);
            data = newdata;
            --i;
        }
        byte[] newdata = new byte[data.length + 4];
        System.arraycopy(data, 0, newdata, 0, data.length);
        newdata[data.length] = Token.FUNCTIONVARARG.getCode();
        newdata[data.length + 1] = (byte)this.arguments;
        IntegerHelper.getTwoBytes(this.function.code, newdata, data.length + 2);
        return newdata;
    }

    int getPrecedence() {
        return 3;
    }
}

