/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import jxl.CellType;
import jxl.NumberCell;
import jxl.NumberFormulaCell;
import jxl.biff.FormattingRecords;
import jxl.biff.FormulaData;
import jxl.biff.IntegerHelper;
import jxl.biff.formula.ExternalSheet;
import jxl.biff.formula.FormulaException;
import jxl.biff.formula.FormulaParser;
import jxl.read.biff.CellValue;
import jxl.read.biff.Record;
import jxl.read.biff.SheetImpl;

class NumberFormulaRecord
extends CellValue
implements NumberCell,
FormulaData,
NumberFormulaCell {
    private double value;
    private NumberFormat format;
    private static final DecimalFormat defaultFormat = new DecimalFormat("#.###");
    private String formulaString;
    private ExternalSheet externalSheet;
    private byte[] data;

    public NumberFormulaRecord(Record t, FormattingRecords fr, ExternalSheet es, SheetImpl si) {
        super(t, fr, si);
        this.externalSheet = es;
        this.data = this.getRecord().getData();
        this.format = fr.getNumberFormat(this.getXFIndex());
        if (this.format == null) {
            this.format = defaultFormat;
        }
        int num1 = IntegerHelper.getInt(this.data[6], this.data[7], this.data[8], this.data[9]);
        int num2 = IntegerHelper.getInt(this.data[10], this.data[11], this.data[12], this.data[13]);
        String s1 = Integer.toBinaryString(num1);
        while (s1.length() < 32) {
            s1 = "0" + s1;
        }
        boolean negative = (num2 & Integer.MIN_VALUE) != 0;
        String s = Integer.toBinaryString(num2 & Integer.MAX_VALUE) + s1;
        long val = Long.parseLong(s, 2);
        this.value = Double.longBitsToDouble(val);
        if (negative) {
            this.value = -this.value;
        }
    }

    public double getValue() {
        return this.value;
    }

    public String getContents() {
        return this.format.format(this.value);
    }

    public CellType getType() {
        return CellType.NUMBER_FORMULA;
    }

    public byte[] getFormulaData() {
        return this.data;
    }

    public String getFormula() throws FormulaException {
        if (this.formulaString == null) {
            byte[] tokens = new byte[this.data.length - 22];
            System.arraycopy(this.data, 22, tokens, 0, tokens.length);
            FormulaParser fp = new FormulaParser(tokens, this, this.externalSheet);
            fp.parse();
            this.formulaString = fp.getFormula();
        }
        return this.formulaString;
    }
}

