/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Assert;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import jxl.Cell;
import jxl.Range;
import jxl.SheetSettings;
import jxl.WorkbookSettings;
import jxl.biff.XFRecord;
import jxl.biff.chart.Chart;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.write.Blank;
import jxl.write.WritableCell;
import jxl.write.WritableHyperlink;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.BOFRecord;
import jxl.write.biff.BottomMarginRecord;
import jxl.write.biff.CalcCountRecord;
import jxl.write.biff.CalcModeRecord;
import jxl.write.biff.CellXFRecord;
import jxl.write.biff.ColumnInfoRecord;
import jxl.write.biff.DBCellRecord;
import jxl.write.biff.DateRecord;
import jxl.write.biff.DefaultColumnWidth;
import jxl.write.biff.DefaultRowHeightRecord;
import jxl.write.biff.DeltaRecord;
import jxl.write.biff.DimensionRecord;
import jxl.write.biff.EOFRecord;
import jxl.write.biff.File;
import jxl.write.biff.FooterRecord;
import jxl.write.biff.GridSetRecord;
import jxl.write.biff.GuttersRecord;
import jxl.write.biff.HeaderRecord;
import jxl.write.biff.HorizontalCentreRecord;
import jxl.write.biff.HorizontalPageBreaksRecord;
import jxl.write.biff.IndexRecord;
import jxl.write.biff.IterationRecord;
import jxl.write.biff.LeftMarginRecord;
import jxl.write.biff.MarginRecord;
import jxl.write.biff.MergedCellsRecord;
import jxl.write.biff.PrintGridLinesRecord;
import jxl.write.biff.PrintHeadersRecord;
import jxl.write.biff.ProtectRecord;
import jxl.write.biff.RefModeRecord;
import jxl.write.biff.RightMarginRecord;
import jxl.write.biff.RowRecord;
import jxl.write.biff.SaveRecalcRecord;
import jxl.write.biff.SelectionRecord;
import jxl.write.biff.SetupRecord;
import jxl.write.biff.TopMarginRecord;
import jxl.write.biff.VerticalCentreRecord;
import jxl.write.biff.Window2Record;
import jxl.write.biff.WorkspaceInformationRecord;
import jxl.write.biff.WritableSheetImpl;

final class SheetWriter {
    private File outputFile;
    private RowRecord[] rows;
    private int numRows;
    private int numCols;
    private HeaderRecord header;
    private FooterRecord footer;
    private SheetSettings settings;
    private WorkbookSettings workbookSettings;
    private ArrayList rowBreaks;
    private ArrayList hyperlinks;
    private ArrayList mergedCells;
    private int workspaceOptions;
    private TreeSet columnFormats;
    private Chart[] charts;
    private WritableSheetImpl sheet;

    public SheetWriter(File of, WritableSheetImpl wsi, WorkbookSettings ws) {
        this.outputFile = of;
        this.sheet = wsi;
        this.workspaceOptions = 1217;
        this.charts = new Chart[0];
        this.workbookSettings = ws;
    }

    public void write() throws IOException {
        MarginRecord mr;
        Assert.verify(this.rows != null);
        int bofpos = this.outputFile.getPos();
        BOFRecord bof = new BOFRecord(BOFRecord.sheet);
        this.outputFile.write(bof);
        int numBlocks = this.numRows / 32;
        if (this.numRows - numBlocks * 32 != 0) {
            ++numBlocks;
        }
        int indexPos = this.outputFile.getPos();
        IndexRecord indexRecord = new IndexRecord(0, this.numRows, numBlocks);
        this.outputFile.write(indexRecord);
        CalcModeRecord cmr = new CalcModeRecord(CalcModeRecord.automatic);
        this.outputFile.write(cmr);
        CalcCountRecord ccr = new CalcCountRecord(100);
        this.outputFile.write(ccr);
        RefModeRecord rmr = new RefModeRecord();
        this.outputFile.write(rmr);
        IterationRecord itr = new IterationRecord(false);
        this.outputFile.write(itr);
        DeltaRecord dtr = new DeltaRecord(0.001);
        this.outputFile.write(dtr);
        SaveRecalcRecord srr = new SaveRecalcRecord(true);
        this.outputFile.write(srr);
        PrintHeadersRecord phr = new PrintHeadersRecord(false);
        this.outputFile.write(phr);
        PrintGridLinesRecord pglr = new PrintGridLinesRecord(false);
        this.outputFile.write(pglr);
        GridSetRecord gsr = new GridSetRecord(true);
        this.outputFile.write(gsr);
        GuttersRecord gutr = new GuttersRecord();
        this.outputFile.write(gutr);
        DefaultRowHeightRecord drhr = new DefaultRowHeightRecord();
        this.outputFile.write(drhr);
        WorkspaceInformationRecord wir = new WorkspaceInformationRecord(this.workspaceOptions);
        this.outputFile.write(wir);
        if (this.rowBreaks.size() > 0) {
            int[] rb = new int[this.rowBreaks.size()];
            int i = 0;
            while (i < rb.length) {
                rb[i] = (Integer)this.rowBreaks.get(i);
                ++i;
            }
            HorizontalPageBreaksRecord hpbr = new HorizontalPageBreaksRecord(rb);
            this.outputFile.write(hpbr);
        }
        if (this.header == null) {
            this.header = new HeaderRecord(null, null, null);
        }
        if (this.footer == null) {
            this.footer = new FooterRecord(null, null, null);
        }
        this.outputFile.write(this.header);
        this.outputFile.write(this.footer);
        HorizontalCentreRecord hcr = new HorizontalCentreRecord(false);
        this.outputFile.write(hcr);
        VerticalCentreRecord vcr = new VerticalCentreRecord(false);
        this.outputFile.write(vcr);
        if (this.settings.getLeftMargin() != this.settings.getDefaultWidthMargin()) {
            mr = new LeftMarginRecord(this.settings.getLeftMargin());
            this.outputFile.write(mr);
        }
        if (this.settings.getRightMargin() != this.settings.getDefaultWidthMargin()) {
            mr = new RightMarginRecord(this.settings.getRightMargin());
            this.outputFile.write(mr);
        }
        if (this.settings.getTopMargin() != this.settings.getDefaultHeightMargin()) {
            mr = new TopMarginRecord(this.settings.getTopMargin());
            this.outputFile.write(mr);
        }
        if (this.settings.getBottomMargin() != this.settings.getDefaultHeightMargin()) {
            mr = new BottomMarginRecord(this.settings.getBottomMargin());
            this.outputFile.write(mr);
        }
        SetupRecord setup = new SetupRecord(this.settings);
        this.outputFile.write(setup);
        if (this.settings.isProtected()) {
            ProtectRecord pr = new ProtectRecord(this.settings.isProtected());
            this.outputFile.write(pr);
        }
        indexRecord.setDataStartPosition(this.outputFile.getPos());
        DefaultColumnWidth dcw = new DefaultColumnWidth(8);
        this.outputFile.write(dcw);
        ColumnInfoRecord cir = null;
        Iterator colit = this.columnFormats.iterator();
        while (colit.hasNext()) {
            cir = (ColumnInfoRecord)colit.next();
            this.outputFile.write(cir);
            XFRecord xfr = cir.getCellFormat();
            if (xfr == WritableWorkbook.NORMAL_STYLE) continue;
            Cell[] cells = this.sheet.getColumn(cir.getColumn());
            int i = 0;
            while (i < cells.length) {
                if (cells[i].getCellFormat() == WritableWorkbook.NORMAL_STYLE || cells[i].getCellFormat() == DateRecord.defaultDateFormat) {
                    ((WritableCell)cells[i]).setCellFormat(xfr);
                }
                ++i;
            }
        }
        Iterator hi = this.hyperlinks.iterator();
        WritableHyperlink hlr = null;
        while (hi.hasNext()) {
            hlr = (WritableHyperlink)hi.next();
            this.outputFile.write(hlr);
        }
        DimensionRecord dr = new DimensionRecord(this.numRows, this.numCols);
        this.outputFile.write(dr);
        int block = 0;
        while (block < numBlocks) {
            DBCellRecord dbcell = new DBCellRecord(this.outputFile.getPos());
            int blockRows = Math.min(32, this.numRows - block * 32);
            boolean firstRow = true;
            int i = block * 32;
            while (i < block * 32 + blockRows) {
                if (this.rows[i] != null) {
                    this.rows[i].write(this.outputFile);
                    if (firstRow) {
                        dbcell.setCellOffset(this.outputFile.getPos());
                        firstRow = false;
                    }
                }
                ++i;
            }
            int i2 = block * 32;
            while (i2 < block * 32 + blockRows) {
                if (this.rows[i2] != null) {
                    dbcell.addCellRowPosition(this.outputFile.getPos());
                    this.rows[i2].writeCells(this.outputFile);
                }
                ++i2;
            }
            indexRecord.addBlockPosition(this.outputFile.getPos());
            dbcell.setPosition(this.outputFile.getPos());
            this.outputFile.write(dbcell);
            ++block;
        }
        if (!this.workbookSettings.getChartsDisabled()) {
            int i = 0;
            while (i < this.charts.length) {
                this.outputFile.write(this.charts[i]);
                ++i;
            }
        }
        Window2Record w2r = new Window2Record(this.settings.isSelected());
        this.outputFile.write(w2r);
        SelectionRecord sr = new SelectionRecord();
        this.outputFile.write(sr);
        if (this.mergedCells.size() > 0) {
            MergedCellsRecord mcr = new MergedCellsRecord(this.sheet);
            Iterator mi = this.mergedCells.iterator();
            while (mi.hasNext()) {
                mcr.add((Range)mi.next());
            }
            this.outputFile.write(mcr);
        }
        EOFRecord eof = new EOFRecord();
        this.outputFile.write(eof);
        this.outputFile.setData(indexRecord.getData(), indexPos + 4);
    }

    void setHeader(HeaderRecord hr) {
        this.header = hr;
    }

    final HeaderRecord getHeader() {
        return this.header;
    }

    final FooterRecord getFooter() {
        return this.footer;
    }

    void setFooter(FooterRecord fr) {
        this.footer = fr;
    }

    void setWriteData(RowRecord[] rws, ArrayList rb, ArrayList hl, ArrayList mc, TreeSet cf) {
        this.rows = rws;
        this.rowBreaks = rb;
        this.hyperlinks = hl;
        this.mergedCells = mc;
        this.columnFormats = cf;
    }

    void setDimensions(int rws, int cls) {
        this.numRows = rws;
        this.numCols = cls;
    }

    void setSettings(SheetSettings sr) {
        this.settings = sr;
    }

    int getWorkspaceOptions() {
        return this.workspaceOptions;
    }

    void setWorkspaceOptions(int wo) {
        this.workspaceOptions = wo;
    }

    void setCharts(Chart[] ch) {
        this.charts = ch;
    }

    Chart[] getCharts() {
        return this.charts;
    }

    void checkMergedBorders() {
        Iterator mi2 = this.mergedCells.iterator();
        ArrayList<CellXFRecord> borderFormats = new ArrayList<CellXFRecord>();
        while (mi2.hasNext()) {
            Range range = (Range)mi2.next();
            Cell topLeft = range.getTopLeft();
            XFRecord tlformat = (XFRecord)topLeft.getCellFormat();
            if (tlformat == null || !tlformat.hasBorders() || tlformat.isRead()) continue;
            try {
                int index;
                CellXFRecord cf1 = new CellXFRecord(tlformat);
                Cell bottomRight = range.getBottomRight();
                cf1.setBorder(Border.ALL, BorderLineStyle.NONE);
                cf1.setBorder(Border.LEFT, tlformat.getBorder(Border.LEFT));
                cf1.setBorder(Border.TOP, tlformat.getBorder(Border.TOP));
                if (topLeft.getRow() == bottomRight.getRow()) {
                    cf1.setBorder(Border.BOTTOM, tlformat.getBorder(Border.BOTTOM));
                }
                if (topLeft.getColumn() == bottomRight.getColumn()) {
                    cf1.setBorder(Border.RIGHT, tlformat.getBorder(Border.RIGHT));
                }
                if ((index = borderFormats.indexOf(cf1)) != -1) {
                    cf1 = (CellXFRecord)borderFormats.get(index);
                } else {
                    borderFormats.add(cf1);
                }
                ((WritableCell)topLeft).setCellFormat(cf1);
                if (bottomRight.getRow() > topLeft.getRow()) {
                    if (bottomRight.getColumn() != topLeft.getColumn()) {
                        CellXFRecord cf2 = new CellXFRecord(tlformat);
                        cf2.setBorder(Border.ALL, BorderLineStyle.NONE);
                        cf2.setBorder(Border.LEFT, tlformat.getBorder(Border.LEFT));
                        cf2.setBorder(Border.BOTTOM, tlformat.getBorder(Border.BOTTOM));
                        index = borderFormats.indexOf(cf2);
                        if (index != -1) {
                            cf2 = (CellXFRecord)borderFormats.get(index);
                        } else {
                            borderFormats.add(cf2);
                        }
                        this.sheet.addCell(new Blank(topLeft.getColumn(), bottomRight.getRow(), cf2));
                    }
                    int i = topLeft.getRow() + 1;
                    while (i < bottomRight.getRow()) {
                        CellXFRecord cf3 = new CellXFRecord(tlformat);
                        cf3.setBorder(Border.ALL, BorderLineStyle.NONE);
                        cf3.setBorder(Border.LEFT, tlformat.getBorder(Border.LEFT));
                        if (topLeft.getColumn() == bottomRight.getColumn()) {
                            cf3.setBorder(Border.RIGHT, tlformat.getBorder(Border.RIGHT));
                        }
                        if ((index = borderFormats.indexOf(cf3)) != -1) {
                            cf3 = (CellXFRecord)borderFormats.get(index);
                        } else {
                            borderFormats.add(cf3);
                        }
                        this.sheet.addCell(new Blank(topLeft.getColumn(), i, cf3));
                        ++i;
                    }
                }
                if (bottomRight.getColumn() > topLeft.getColumn()) {
                    if (bottomRight.getRow() != topLeft.getRow()) {
                        CellXFRecord cf6 = new CellXFRecord(tlformat);
                        cf6.setBorder(Border.ALL, BorderLineStyle.NONE);
                        cf6.setBorder(Border.RIGHT, tlformat.getBorder(Border.RIGHT));
                        cf6.setBorder(Border.TOP, tlformat.getBorder(Border.TOP));
                        index = borderFormats.indexOf(cf6);
                        if (index != -1) {
                            cf6 = (CellXFRecord)borderFormats.get(index);
                        } else {
                            borderFormats.add(cf6);
                        }
                        this.sheet.addCell(new Blank(bottomRight.getColumn(), topLeft.getRow(), cf6));
                    }
                    int i = topLeft.getRow() + 1;
                    while (i < bottomRight.getRow()) {
                        CellXFRecord cf7 = new CellXFRecord(tlformat);
                        cf7.setBorder(Border.ALL, BorderLineStyle.NONE);
                        cf7.setBorder(Border.RIGHT, tlformat.getBorder(Border.RIGHT));
                        index = borderFormats.indexOf(cf7);
                        if (index != -1) {
                            cf7 = (CellXFRecord)borderFormats.get(index);
                        } else {
                            borderFormats.add(cf7);
                        }
                        this.sheet.addCell(new Blank(bottomRight.getColumn(), i, cf7));
                        ++i;
                    }
                    int i2 = topLeft.getColumn() + 1;
                    while (i2 < bottomRight.getColumn()) {
                        CellXFRecord cf8 = new CellXFRecord(tlformat);
                        cf8.setBorder(Border.ALL, BorderLineStyle.NONE);
                        cf8.setBorder(Border.TOP, tlformat.getBorder(Border.TOP));
                        if (topLeft.getRow() == bottomRight.getRow()) {
                            cf8.setBorder(Border.BOTTOM, tlformat.getBorder(Border.BOTTOM));
                        }
                        if ((index = borderFormats.indexOf(cf8)) != -1) {
                            cf8 = (CellXFRecord)borderFormats.get(index);
                        } else {
                            borderFormats.add(cf8);
                        }
                        this.sheet.addCell(new Blank(i2, topLeft.getRow(), cf8));
                        ++i2;
                    }
                }
                if (bottomRight.getColumn() <= topLeft.getColumn() && bottomRight.getRow() <= topLeft.getRow()) continue;
                CellXFRecord cf4 = new CellXFRecord(tlformat);
                cf4.setBorder(Border.ALL, BorderLineStyle.NONE);
                cf4.setBorder(Border.RIGHT, tlformat.getBorder(Border.RIGHT));
                cf4.setBorder(Border.BOTTOM, tlformat.getBorder(Border.BOTTOM));
                if (bottomRight.getRow() == topLeft.getRow()) {
                    cf4.setBorder(Border.TOP, tlformat.getBorder(Border.TOP));
                }
                if (bottomRight.getColumn() == topLeft.getColumn()) {
                    cf4.setBorder(Border.LEFT, tlformat.getBorder(Border.LEFT));
                }
                if ((index = borderFormats.indexOf(cf4)) != -1) {
                    cf4 = (CellXFRecord)borderFormats.get(index);
                } else {
                    borderFormats.add(cf4);
                }
                this.sheet.addCell(new Blank(bottomRight.getColumn(), bottomRight.getRow(), cf4));
                int i = topLeft.getColumn() + 1;
                while (i < bottomRight.getColumn()) {
                    CellXFRecord cf5 = new CellXFRecord(tlformat);
                    cf5.setBorder(Border.ALL, BorderLineStyle.NONE);
                    cf5.setBorder(Border.BOTTOM, tlformat.getBorder(Border.BOTTOM));
                    if (topLeft.getRow() == bottomRight.getRow()) {
                        cf5.setBorder(Border.TOP, tlformat.getBorder(Border.TOP));
                    }
                    if ((index = borderFormats.indexOf(cf5)) != -1) {
                        cf5 = (CellXFRecord)borderFormats.get(index);
                    } else {
                        borderFormats.add(cf5);
                    }
                    this.sheet.addCell(new Blank(i, bottomRight.getRow(), cf5));
                    ++i;
                }
            }
            catch (WriteException e) {
                System.err.println(e.toString());
            }
        }
    }
}

