/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Date;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.DateCommonBinder;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OraclePreparedStatementReadOnly;

class DateBinder
extends DateCommonBinder {
    Binder theDateCopyingBinder = OraclePreparedStatementReadOnly.theStaticDateCopyingBinder;

    static void init(Binder x) {
        x.type = (short)12;
        x.bytelen = 7;
    }

    DateBinder() {
        DateBinder.init(this);
    }

    Binder copyingBinder() {
        return this.theDateCopyingBinder;
    }

    void bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues) {
        Date[] dates = stmt.parameterDate[rank];
        Date value = dates[bindPosition];
        if (clearPriorBindValues) {
            dates[bindPosition] = null;
        }
        if (value == null) {
            bindIndicators[indoffset] = -1;
        } else {
            bindIndicators[indoffset] = 0;
            long millis = DateBinder.setOracleCYMD(value.getTime(), bindBytes, byteoffset, stmt);
            bindBytes[6 + byteoffset] = 1;
            bindBytes[5 + byteoffset] = 1;
            bindBytes[4 + byteoffset] = 1;
            bindIndicators[lenoffset] = (short)bytePitch;
        }
    }
}

