/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.ParameterMetadataProvider;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.util.Assert;

public class JpaQueryCreator
extends AbstractQueryCreator<CriteriaQuery<Object>, Predicate> {
    private final CriteriaBuilder builder;
    private final Root<?> root;
    private final CriteriaQuery<Object> query;
    private final ParameterMetadataProvider provider;
    private HashMap mValues;

    public JpaQueryCreator(PartTree tree, Class<?> domainClass, CriteriaBuilder builder, ParameterMetadataProvider provider) {
        super(tree);
        this.builder = builder;
        this.query = builder.createQuery().distinct(tree.isDistinct());
        this.root = this.query.from(domainClass);
        this.provider = provider;
    }

    public JpaQueryCreator(PartTree tree, Class<?> domainClass, CriteriaBuilder builder, ParameterMetadataProvider provider, HashMap mValues) {
        super(tree);
        this.builder = builder;
        this.query = builder.createQuery().distinct(tree.isDistinct());
        this.root = this.query.from(domainClass);
        this.provider = provider;
        this.mValues = mValues;
    }

    public List<ParameterMetadataProvider.ParameterMetadata<?>> getParameterExpressions() {
        return this.provider.getExpressions();
    }

    protected Predicate create(Part part, Iterator<Object> iterator) {
        return this.toPredicate(part, this.root);
    }

    protected Predicate and(Part part, Predicate base, Iterator<Object> iterator) {
        Predicate predicatePart = this.toPredicate(part, this.root);
        if (predicatePart == null) {
            return base;
        }
        return this.builder.and((Expression)base, (Expression)predicatePart);
    }

    protected Predicate or(Predicate base, Predicate predicate) {
        if (predicate == null) {
            return base;
        }
        return this.builder.or((Expression)base, (Expression)predicate);
    }

    protected final CriteriaQuery<Object> complete(Predicate predicate, Sort sort) {
        return this.complete(predicate, sort, this.query, this.builder, this.root);
    }

    protected CriteriaQuery<Object> complete(Predicate predicate, Sort sort, CriteriaQuery<Object> query, CriteriaBuilder builder, Root<?> root) {
        CriteriaQuery select = this.query.select(root).orderBy(QueryUtils.toOrders(sort, root, builder));
        return predicate == null ? select : select.where((Expression)predicate);
    }

    private Predicate toPredicate(Part part, Root<?> root) {
        return new PredicateBuilder(part, root).build();
    }

    private Expression<? extends Comparable> getComparablePath(Root<?> root, Part part) {
        return this.getTypedPath(root, part);
    }

    private <T> Expression<T> getTypedPath(Root<?> root, Part part) {
        return QueryUtils.toExpressionRecursively(root, part.getProperty());
    }

    private class PredicateBuilder {
        private final Part part;
        private final Root<?> root;

        public PredicateBuilder(Part part, Root<?> root) {
            Assert.notNull((Object)part);
            Assert.notNull(root);
            this.part = part;
            this.root = root;
        }

        public Predicate build() {
            PropertyPath property = this.part.getProperty();
            Expression path = QueryUtils.toExpressionRecursively(this.root, property);
            if (JpaQueryCreator.this.mValues != null && "0".equals(JpaQueryCreator.this.mValues.get(this.part))) {
                return null;
            }
            switch (this.part.getType()) {
                case BETWEEN: {
                    ParameterMetadataProvider.ParameterMetadata first = JpaQueryCreator.this.provider.next(this.part);
                    ParameterMetadataProvider.ParameterMetadata second = JpaQueryCreator.this.provider.next(this.part);
                    return JpaQueryCreator.this.builder.between(JpaQueryCreator.this.getComparablePath(this.root, this.part), first.getExpression(), second.getExpression());
                }
                case GREATER_THAN: 
                case AFTER: {
                    return JpaQueryCreator.this.builder.greaterThan(JpaQueryCreator.this.getComparablePath(this.root, this.part), JpaQueryCreator.this.provider.next(this.part, Comparable.class).getExpression());
                }
                case GREATER_THAN_EQUAL: {
                    return JpaQueryCreator.this.builder.greaterThanOrEqualTo(JpaQueryCreator.this.getComparablePath(this.root, this.part), JpaQueryCreator.this.provider.next(this.part, Comparable.class).getExpression());
                }
                case LESS_THAN: 
                case BEFORE: {
                    return JpaQueryCreator.this.builder.lessThan(JpaQueryCreator.this.getComparablePath(this.root, this.part), JpaQueryCreator.this.provider.next(this.part, Comparable.class).getExpression());
                }
                case LESS_THAN_EQUAL: {
                    return JpaQueryCreator.this.builder.lessThanOrEqualTo(JpaQueryCreator.this.getComparablePath(this.root, this.part), JpaQueryCreator.this.provider.next(this.part, Comparable.class).getExpression());
                }
                case IS_NULL: {
                    return path.isNull();
                }
                case IS_NOT_NULL: {
                    return path.isNotNull();
                }
                case NOT_IN: {
                    return path.in(new Expression[]{JpaQueryCreator.this.provider.next(this.part, Collection.class).getExpression()}).not();
                }
                case IN: {
                    return path.in(new Expression[]{JpaQueryCreator.this.provider.next(this.part, Collection.class).getExpression()});
                }
                case NOT_LIKE: 
                case LIKE: 
                case STARTING_WITH: 
                case ENDING_WITH: 
                case CONTAINING: {
                    Expression stringPath = JpaQueryCreator.this.getTypedPath(this.root, this.part);
                    Expression propertyExpression = this.upperIfIgnoreCase(stringPath);
                    Expression<String> parameterExpression = this.upperIfIgnoreCase((Expression)JpaQueryCreator.this.provider.next(this.part, String.class).getExpression());
                    Predicate like = JpaQueryCreator.this.builder.like(propertyExpression, parameterExpression);
                    return this.part.getType() == Part.Type.NOT_LIKE ? like.not() : like;
                }
                case TRUE: {
                    Expression truePath = JpaQueryCreator.this.getTypedPath(this.root, this.part);
                    return JpaQueryCreator.this.builder.isTrue(truePath);
                }
                case FALSE: {
                    Expression falsePath = JpaQueryCreator.this.getTypedPath(this.root, this.part);
                    return JpaQueryCreator.this.builder.isFalse(falsePath);
                }
                case SIMPLE_PROPERTY: {
                    ParameterMetadataProvider.ParameterMetadata expression = JpaQueryCreator.this.provider.next(this.part);
                    return expression.isIsNullParameter() ? path.isNull() : JpaQueryCreator.this.builder.equal(this.upperIfIgnoreCase(path), this.upperIfIgnoreCase((Expression)expression.getExpression()));
                }
                case NEGATING_SIMPLE_PROPERTY: {
                    return JpaQueryCreator.this.builder.notEqual(this.upperIfIgnoreCase(path), this.upperIfIgnoreCase((Expression)JpaQueryCreator.this.provider.next(this.part).getExpression()));
                }
            }
            throw new IllegalArgumentException("Unsupported keyword " + this.part.getType());
        }

        private <T> Expression<T> upperIfIgnoreCase(Expression<? extends T> expression) {
            switch (this.part.shouldIgnoreCase()) {
                case ALWAYS: {
                    Assert.state((boolean)this.canUpperCase(expression), (String)("Unable to ignore case of " + expression.getJavaType().getName() + " types, the property '" + this.part.getProperty().getSegment() + "' must reference a String"));
                    return JpaQueryCreator.this.builder.upper(expression);
                }
                case WHEN_POSSIBLE: {
                    if (!this.canUpperCase(expression)) break;
                    return JpaQueryCreator.this.builder.upper(expression);
                }
            }
            return expression;
        }

        private boolean canUpperCase(Expression<?> expression) {
            return String.class.equals((Object)expression.getJavaType());
        }
    }
}

